package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata.SVGGenerator;
import org.kie.workbench.common.stunner.project.diagram.impl.ProjectMetadataImpl;
import org.uberfire.backend.vfs.Path;

public class Marshaller_o_k_w_c_s_p_d_i_ProjectMetadataImpl_1_Impl implements GeneratedMarshaller<ProjectMetadataImpl> {
  private ProjectMetadataImpl[] EMPTY_ARRAY = new ProjectMetadataImpl[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Package> org_guvnor_common_services_project_model_Package = null;
  private Marshaller<Overview> org_guvnor_common_services_shared_metadata_model_Overview = null;
  private Marshaller<SVGGenerator> org_kie_workbench_common_stunner_project_diagram_ProjectMetadata_erraiD_SVGGenerator = null;
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public ProjectMetadataImpl[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public native static ProjectMetadataImpl ProjectMetadataImpl__String_Package_Overview_String_String_SVGGenerator_Path(String a0, Package a1, Overview a2, String a3, String a4, SVGGenerator a5, Path a6) /*-{
    return @org.kie.workbench.common.stunner.project.diagram.impl.ProjectMetadataImpl::new(Ljava/lang/String;Lorg/guvnor/common/services/project/model/Package;Lorg/guvnor/common/services/shared/metadata/model/Overview;Ljava/lang/String;Ljava/lang/String;Lorg/kie/workbench/common/stunner/project/diagram/ProjectMetadata$SVGGenerator;Lorg/uberfire/backend/vfs/Path;)(a0, a1, a2, a3, a4, a5, a6);
  }-*/;

  native static Package ProjectMetadataImpl_Package_projectPkg(ProjectMetadataImpl instance) /*-{
    return instance.@org.kie.workbench.common.stunner.project.diagram.impl.ProjectMetadataImpl::projectPkg;
  }-*/;

  native static void ProjectMetadataImpl_Package_projectPkg(ProjectMetadataImpl instance, Package value) /*-{
    instance.@org.kie.workbench.common.stunner.project.diagram.impl.ProjectMetadataImpl::projectPkg = value;
  }-*/;

  public ProjectMetadataImpl demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ProjectMetadataImpl.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("definitionSetId"), a1);
    final Package c1 = org_guvnor_common_services_project_model_Package.demarshall(obj.get("projectPkg"), a1);
    final Overview c2 = org_guvnor_common_services_shared_metadata_model_Overview.demarshall(obj.get("overview"), a1);
    final String c3 = java_lang_String.demarshall(obj.get("moduleName"), a1);
    final String c4 = java_lang_String.demarshall(obj.get("projectType"), a1);
    final SVGGenerator c5 = obj.get("diagramSVGGenerator").isObject() != null ? Enum.valueOf(SVGGenerator.class, obj.get("diagramSVGGenerator").isObject().get("^EnumStringValue").isString().stringValue()) : obj.get("diagramSVGGenerator").isString() != null ? Enum.valueOf(SVGGenerator.class, obj.get("diagramSVGGenerator").isString().stringValue()) : null;
    final Path c6 = (Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, obj.get("diagramSVGPath"), a1);
    ProjectMetadataImpl entity = ProjectMetadataImpl__String_Package_Overview_String_String_SVGGenerator_Path(c0, c1, c2, c3, c4, c5, c6);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "projectPkg": ProjectMetadataImpl_Package_projectPkg(entity, org_guvnor_common_services_project_model_Package.demarshall(objVal, a1));
        break;
        case "definitionSetId": entity.setDefinitionSetId(java_lang_String.demarshall(objVal, a1));
        break;
        case "profileId": entity.setProfileId(java_lang_String.demarshall(objVal, a1));
        break;
        case "title": entity.setTitle(java_lang_String.demarshall(objVal, a1));
        break;
        case "shapeSetId": entity.setShapeSetId(java_lang_String.demarshall(objVal, a1));
        break;
        case "canvasRootUUID": entity.setCanvasRootUUID(java_lang_String.demarshall(objVal, a1));
        break;
        case "thumbData": entity.setThumbData(java_lang_String.demarshall(objVal, a1));
        break;
        case "root": entity.setRoot((Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
        case "path": entity.setPath((Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(ProjectMetadataImpl a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.project.diagram.impl.ProjectMetadataImpl") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "moduleName") + "\":") + java_lang_String.marshall(a0.getModuleName(), a1)) + ",\"") + "projectPkg") + "\":") + org_guvnor_common_services_project_model_Package.marshall(ProjectMetadataImpl_Package_projectPkg(a0), a1)) + ",\"") + "overview") + "\":") + org_guvnor_common_services_shared_metadata_model_Overview.marshall(a0.getOverview(), a1)) + ",\"") + "projectType") + "\":") + java_lang_String.marshall(a0.getProjectType(), a1)) + ",\"") + "diagramSVGGenerator") + "\":") + (a0.getDiagramSVGGenerator() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.project.diagram.ProjectMetadata$SVGGenerator") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getDiagramSVGGenerator().name()) + "\"}" : "null")) + ",\"") + "diagramSVGPath") + "\":") + java_lang_Object.marshall(a0.getDiagramSVGPath(), a1)) + ",\"") + "definitionSetId") + "\":") + java_lang_String.marshall(a0.getDefinitionSetId(), a1)) + ",\"") + "profileId") + "\":") + java_lang_String.marshall(a0.getProfileId(), a1)) + ",\"") + "title") + "\":") + java_lang_String.marshall(a0.getTitle(), a1)) + ",\"") + "shapeSetId") + "\":") + java_lang_String.marshall(a0.getShapeSetId(), a1)) + ",\"") + "canvasRootUUID") + "\":") + java_lang_String.marshall(a0.getCanvasRootUUID(), a1)) + ",\"") + "thumbData") + "\":") + java_lang_String.marshall(a0.getThumbData(), a1)) + ",\"") + "root") + "\":") + java_lang_Object.marshall(a0.getRoot(), a1)) + ",\"") + "path") + "\":") + java_lang_Object.marshall(a0.getPath(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_guvnor_common_services_project_model_Package == null) {
      org_guvnor_common_services_project_model_Package = Marshalling.getMarshaller(Package.class);
    }
    if (org_guvnor_common_services_shared_metadata_model_Overview == null) {
      org_guvnor_common_services_shared_metadata_model_Overview = Marshalling.getMarshaller(Overview.class);
    }
    if (org_kie_workbench_common_stunner_project_diagram_ProjectMetadata_erraiD_SVGGenerator == null) {
      org_kie_workbench_common_stunner_project_diagram_ProjectMetadata_erraiD_SVGGenerator = Marshalling.getMarshaller(SVGGenerator.class);
    }
  }
}