package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.guvnor.common.services.project.model.ModuleRepositories;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.ProjectImports;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.screens.projecteditor.model.ProjectScreenModel;
import org.kie.workbench.common.services.shared.kmodule.KModuleModel;
import org.kie.workbench.common.services.shared.whitelist.WhiteList;
import org.uberfire.backend.vfs.Path;

public class Marshaller_o_k_w_c_s_p_m_ProjectScreenModel_1_Impl implements GeneratedMarshaller<ProjectScreenModel> {
  private ProjectScreenModel[] EMPTY_ARRAY = new ProjectScreenModel[0];
  private Marshaller<POM> org_guvnor_common_services_project_model_POM = null;
  private Marshaller<KModuleModel> org_kie_workbench_common_services_shared_kmodule_KModuleModel = null;
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<ProjectImports> org_guvnor_common_services_project_model_ProjectImports = null;
  private Marshaller<ModuleRepositories> org_guvnor_common_services_project_model_ModuleRepositories = null;
  private Marshaller<WhiteList> org_kie_workbench_common_services_shared_whitelist_WhiteList = null;
  private Marshaller<Metadata> org_guvnor_common_services_shared_metadata_model_Metadata = null;
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public ProjectScreenModel[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ProjectScreenModel demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ProjectScreenModel.class, objId);
    }
    ProjectScreenModel entity = new ProjectScreenModel();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "pom": entity.setPOM(org_guvnor_common_services_project_model_POM.demarshall(objVal, a1));
        break;
        case "KModule": entity.setKModule(org_kie_workbench_common_services_shared_kmodule_KModuleModel.demarshall(objVal, a1));
        break;
        case "gitUrls": a1.setAssumedElementType("org.kie.workbench.common.screens.projecteditor.model.GitUrl");
        entity.setGitUrls(java_util_List.demarshall(objVal, a1));
        break;
        case "projectImports": entity.setProjectImports(org_guvnor_common_services_project_model_ProjectImports.demarshall(objVal, a1));
        break;
        case "repositories": entity.setRepositories(org_guvnor_common_services_project_model_ModuleRepositories.demarshall(objVal, a1));
        break;
        case "whiteList": entity.setWhiteList(org_kie_workbench_common_services_shared_whitelist_WhiteList.demarshall(objVal, a1));
        break;
        case "POMMetaData": entity.setPOMMetaData(org_guvnor_common_services_shared_metadata_model_Metadata.demarshall(objVal, a1));
        break;
        case "KModuleMetaData": entity.setKModuleMetaData(org_guvnor_common_services_shared_metadata_model_Metadata.demarshall(objVal, a1));
        break;
        case "projectImportsMetaData": entity.setProjectImportsMetaData(org_guvnor_common_services_shared_metadata_model_Metadata.demarshall(objVal, a1));
        break;
        case "projectTagsMetaData": entity.setProjectTagsMetaData(org_guvnor_common_services_shared_metadata_model_Metadata.demarshall(objVal, a1));
        break;
        case "whiteListMetaData": entity.setWhiteListMetaData(org_guvnor_common_services_shared_metadata_model_Metadata.demarshall(objVal, a1));
        break;
        case "pathToPOM": entity.setPathToPOM((Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
        case "pathToKModule": entity.setPathToKModule((Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
        case "pathToImports": entity.setPathToImports((Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
        case "pathToRepositories": entity.setPathToRepositories((Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
        case "pathToWhiteList": entity.setPathToWhiteList((Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(ProjectScreenModel a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.projecteditor.model.ProjectScreenModel") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "pom") + "\":") + org_guvnor_common_services_project_model_POM.marshall(a0.getPOM(), a1)) + ",\"") + "KModule") + "\":") + org_kie_workbench_common_services_shared_kmodule_KModuleModel.marshall(a0.getKModule(), a1)) + ",\"") + "gitUrls") + "\":") + java_util_List.marshall(a0.getGitUrls(), a1)) + ",\"") + "projectImports") + "\":") + org_guvnor_common_services_project_model_ProjectImports.marshall(a0.getProjectImports(), a1)) + ",\"") + "repositories") + "\":") + org_guvnor_common_services_project_model_ModuleRepositories.marshall(a0.getRepositories(), a1)) + ",\"") + "whiteList") + "\":") + org_kie_workbench_common_services_shared_whitelist_WhiteList.marshall(a0.getWhiteList(), a1)) + ",\"") + "POMMetaData") + "\":") + org_guvnor_common_services_shared_metadata_model_Metadata.marshall(a0.getPOMMetaData(), a1)) + ",\"") + "KModuleMetaData") + "\":") + org_guvnor_common_services_shared_metadata_model_Metadata.marshall(a0.getKModuleMetaData(), a1)) + ",\"") + "projectImportsMetaData") + "\":") + org_guvnor_common_services_shared_metadata_model_Metadata.marshall(a0.getProjectImportsMetaData(), a1)) + ",\"") + "projectTagsMetaData") + "\":") + org_guvnor_common_services_shared_metadata_model_Metadata.marshall(a0.getProjectTagsMetaData(), a1)) + ",\"") + "whiteListMetaData") + "\":") + org_guvnor_common_services_shared_metadata_model_Metadata.marshall(a0.getWhiteListMetaData(), a1)) + ",\"") + "pathToPOM") + "\":") + java_lang_Object.marshall(a0.getPathToPOM(), a1)) + ",\"") + "pathToKModule") + "\":") + java_lang_Object.marshall(a0.getPathToKModule(), a1)) + ",\"") + "pathToImports") + "\":") + java_lang_Object.marshall(a0.getPathToImports(), a1)) + ",\"") + "pathToRepositories") + "\":") + java_lang_Object.marshall(a0.getPathToRepositories(), a1)) + ",\"") + "pathToWhiteList") + "\":") + java_lang_Object.marshall(a0.getPathToWhiteList(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_guvnor_common_services_project_model_POM == null) {
      org_guvnor_common_services_project_model_POM = Marshalling.getMarshaller(POM.class);
    }
    if (org_kie_workbench_common_services_shared_kmodule_KModuleModel == null) {
      org_kie_workbench_common_services_shared_kmodule_KModuleModel = Marshalling.getMarshaller(KModuleModel.class);
    }
    if (org_guvnor_common_services_project_model_ProjectImports == null) {
      org_guvnor_common_services_project_model_ProjectImports = Marshalling.getMarshaller(ProjectImports.class);
    }
    if (org_guvnor_common_services_project_model_ModuleRepositories == null) {
      org_guvnor_common_services_project_model_ModuleRepositories = Marshalling.getMarshaller(ModuleRepositories.class);
    }
    if (org_kie_workbench_common_services_shared_whitelist_WhiteList == null) {
      org_kie_workbench_common_services_shared_whitelist_WhiteList = Marshalling.getMarshaller(WhiteList.class);
    }
    if (org_guvnor_common_services_shared_metadata_model_Metadata == null) {
      org_guvnor_common_services_shared_metadata_model_Metadata = Marshalling.getMarshaller(Metadata.class);
    }
  }
}