package org.jboss.errai.marshalling.client.api;

import java.util.HashMap;
import java.util.Set;
import org.guvnor.common.services.project.model.GAV;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.services.shared.dependencies.EnhancedDependencies;
import org.kie.workbench.common.services.shared.dependencies.EnhancedDependency;

public class Marshaller_o_k_w_c_s_s_d_EnhancedDependencies_1_Impl implements GeneratedMarshaller<EnhancedDependencies> {
  private EnhancedDependencies[] EMPTY_ARRAY = new EnhancedDependencies[0];
  private Marshaller<HashMap> java_util_HashMap = null;
  public EnhancedDependencies[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static HashMap EnhancedDependencies_HashMap_enhancedDependencies(EnhancedDependencies instance) /*-{
    return instance.@org.kie.workbench.common.services.shared.dependencies.EnhancedDependencies::enhancedDependencies;
  }-*/;

  native static void EnhancedDependencies_HashMap_enhancedDependencies(EnhancedDependencies instance, HashMap<GAV, EnhancedDependency> value) /*-{
    instance.@org.kie.workbench.common.services.shared.dependencies.EnhancedDependencies::enhancedDependencies = value;
  }-*/;

  public EnhancedDependencies demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(EnhancedDependencies.class, objId);
    }
    EnhancedDependencies entity = new EnhancedDependencies();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "enhancedDependencies": a1.setAssumedMapKeyType("org.guvnor.common.services.project.model.GAV");
        a1.setAssumedMapValueType("org.kie.workbench.common.services.shared.dependencies.EnhancedDependency");
        EnhancedDependencies_HashMap_enhancedDependencies(entity, java_util_HashMap.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
      }
    }
    return entity;
  }

  public String marshall(EnhancedDependencies a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.shared.dependencies.EnhancedDependencies") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "enhancedDependencies") + "\":") + java_util_HashMap.marshall(EnhancedDependencies_HashMap_enhancedDependencies(a0), a1)) + "}");
  }

  private void lazyInit() {
    if (java_util_HashMap == null) {
      java_util_HashMap = Marshalling.getMarshaller(HashMap.class);
    }
  }
}