package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.guvnor.common.services.project.model.Dependency;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.services.shared.dependencies.EnhancedDependencies;
import org.kie.workbench.common.services.shared.dependencies.EnhancedDependency;
import org.kie.workbench.common.services.shared.dependencies.NormalEnhancedDependency;

public class Marshaller_o_k_w_c_s_s_d_NormalEnhancedDependency_1_Impl implements GeneratedMarshaller<NormalEnhancedDependency> {
  private NormalEnhancedDependency[] EMPTY_ARRAY = new NormalEnhancedDependency[0];
  private Marshaller<EnhancedDependencies> org_kie_workbench_common_services_shared_dependencies_EnhancedDependencies = null;
  private Marshaller<Dependency> org_guvnor_common_services_project_model_Dependency = null;
  private Marshaller<Set> java_util_Set = Marshalling.getMarshaller(Set.class);
  public NormalEnhancedDependency[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static EnhancedDependencies NormalEnhancedDependency_EnhancedDependencies_transitiveDependencies(NormalEnhancedDependency instance) /*-{
    return instance.@org.kie.workbench.common.services.shared.dependencies.NormalEnhancedDependency::transitiveDependencies;
  }-*/;

  native static void NormalEnhancedDependency_EnhancedDependencies_transitiveDependencies(NormalEnhancedDependency instance, EnhancedDependencies value) /*-{
    instance.@org.kie.workbench.common.services.shared.dependencies.NormalEnhancedDependency::transitiveDependencies = value;
  }-*/;

  native static Dependency EnhancedDependency_Dependency_dependency(EnhancedDependency instance) /*-{
    return instance.@org.kie.workbench.common.services.shared.dependencies.EnhancedDependency::dependency;
  }-*/;

  native static void EnhancedDependency_Dependency_dependency(EnhancedDependency instance, Dependency value) /*-{
    instance.@org.kie.workbench.common.services.shared.dependencies.EnhancedDependency::dependency = value;
  }-*/;

  native static Set EnhancedDependency_Set_packageNames(EnhancedDependency instance) /*-{
    return instance.@org.kie.workbench.common.services.shared.dependencies.EnhancedDependency::packageNames;
  }-*/;

  native static void EnhancedDependency_Set_packageNames(EnhancedDependency instance, Set<String> value) /*-{
    instance.@org.kie.workbench.common.services.shared.dependencies.EnhancedDependency::packageNames = value;
  }-*/;

  public NormalEnhancedDependency demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(NormalEnhancedDependency.class, objId);
    }
    NormalEnhancedDependency entity = new NormalEnhancedDependency();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "transitiveDependencies": NormalEnhancedDependency_EnhancedDependencies_transitiveDependencies(entity, org_kie_workbench_common_services_shared_dependencies_EnhancedDependencies.demarshall(objVal, a1));
        break;
        case "dependency": EnhancedDependency_Dependency_dependency(entity, org_guvnor_common_services_project_model_Dependency.demarshall(objVal, a1));
        break;
        case "packageNames": a1.setAssumedElementType("java.lang.String");
        EnhancedDependency_Set_packageNames(entity, java_util_Set.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(NormalEnhancedDependency a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.shared.dependencies.NormalEnhancedDependency") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "transitiveDependencies") + "\":") + org_kie_workbench_common_services_shared_dependencies_EnhancedDependencies.marshall(a0.getTransitiveDependencies(), a1)) + ",\"") + "dependency") + "\":") + org_guvnor_common_services_project_model_Dependency.marshall(a0.getDependency(), a1)) + ",\"") + "packageNames") + "\":") + java_util_Set.marshall(EnhancedDependency_Set_packageNames(a0), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_services_shared_dependencies_EnhancedDependencies == null) {
      org_kie_workbench_common_services_shared_dependencies_EnhancedDependencies = Marshalling.getMarshaller(EnhancedDependencies.class);
    }
    if (org_guvnor_common_services_project_model_Dependency == null) {
      org_guvnor_common_services_project_model_Dependency = Marshalling.getMarshaller(Dependency.class);
    }
  }
}