package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.services.shared.kmodule.AssertBehaviorOption;
import org.kie.workbench.common.services.shared.kmodule.DeclarativeAgendaOption;
import org.kie.workbench.common.services.shared.kmodule.EventProcessingOption;
import org.kie.workbench.common.services.shared.kmodule.KBaseModel;
import org.kie.workbench.common.services.shared.kmodule.KSessionModel;
import org.kie.workbench.common.services.shared.kmodule.SingleValueItemObjectModel;

public class Marshaller_o_k_w_c_s_s_k_KBaseModel_1_Impl implements GeneratedMarshaller<KBaseModel> {
  private KBaseModel[] EMPTY_ARRAY = new KBaseModel[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<AssertBehaviorOption> org_kie_workbench_common_services_shared_kmodule_AssertBehaviorOption = null;
  private Marshaller<EventProcessingOption> org_kie_workbench_common_services_shared_kmodule_EventProcessingOption = null;
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<DeclarativeAgendaOption> org_kie_workbench_common_services_shared_kmodule_DeclarativeAgendaOption = null;
  public KBaseModel[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static List KBaseModel_List_kSessions(KBaseModel instance) /*-{
    return instance.@org.kie.workbench.common.services.shared.kmodule.KBaseModel::kSessions;
  }-*/;

  native static void KBaseModel_List_kSessions(KBaseModel instance, List<KSessionModel> value) /*-{
    instance.@org.kie.workbench.common.services.shared.kmodule.KBaseModel::kSessions = value;
  }-*/;

  native static List KBaseModel_List_includes(KBaseModel instance) /*-{
    return instance.@org.kie.workbench.common.services.shared.kmodule.KBaseModel::includes;
  }-*/;

  native static void KBaseModel_List_includes(KBaseModel instance, List<SingleValueItemObjectModel> value) /*-{
    instance.@org.kie.workbench.common.services.shared.kmodule.KBaseModel::includes = value;
  }-*/;

  native static boolean KBaseModel_boolean_theDefault(KBaseModel instance) /*-{
    return instance.@org.kie.workbench.common.services.shared.kmodule.KBaseModel::theDefault;
  }-*/;

  native static void KBaseModel_boolean_theDefault(KBaseModel instance, boolean value) /*-{
    instance.@org.kie.workbench.common.services.shared.kmodule.KBaseModel::theDefault = value;
  }-*/;

  native static List KBaseModel_List_packages(KBaseModel instance) /*-{
    return instance.@org.kie.workbench.common.services.shared.kmodule.KBaseModel::packages;
  }-*/;

  native static void KBaseModel_List_packages(KBaseModel instance, List<SingleValueItemObjectModel> value) /*-{
    instance.@org.kie.workbench.common.services.shared.kmodule.KBaseModel::packages = value;
  }-*/;

  public KBaseModel demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(KBaseModel.class, objId);
    }
    KBaseModel entity = new KBaseModel();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
        case "equalsBehavior": entity.setEqualsBehavior(objVal.isObject() != null ? Enum.valueOf(AssertBehaviorOption.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(AssertBehaviorOption.class, objVal.isString().stringValue()) : null);
        break;
        case "eventProcessingMode": entity.setEventProcessingMode(objVal.isObject() != null ? Enum.valueOf(EventProcessingOption.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(EventProcessingOption.class, objVal.isString().stringValue()) : null);
        break;
        case "kSessions": a1.setAssumedElementType("org.kie.workbench.common.services.shared.kmodule.KSessionModel");
        KBaseModel_List_kSessions(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "includes": a1.setAssumedElementType("org.kie.workbench.common.services.shared.kmodule.SingleValueItemObjectModel");
        KBaseModel_List_includes(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "theDefault": KBaseModel_boolean_theDefault(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "scope": entity.setScope(java_lang_String.demarshall(objVal, a1));
        break;
        case "packages": a1.setAssumedElementType("org.kie.workbench.common.services.shared.kmodule.SingleValueItemObjectModel");
        KBaseModel_List_packages(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "declarativeAgenda": entity.setDeclarativeAgenda(objVal.isObject() != null ? Enum.valueOf(DeclarativeAgendaOption.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(DeclarativeAgendaOption.class, objVal.isString().stringValue()) : null);
        break;
      }
    }
    return entity;
  }

  public String marshall(KBaseModel a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.shared.kmodule.KBaseModel") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "equalsBehavior") + "\":") + (a0.getEqualsBehavior() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.shared.kmodule.AssertBehaviorOption") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getEqualsBehavior().name()) + "\"}" : "null")) + ",\"") + "eventProcessingMode") + "\":") + (a0.getEventProcessingMode() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.shared.kmodule.EventProcessingOption") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getEventProcessingMode().name()) + "\"}" : "null")) + ",\"") + "kSessions") + "\":") + java_util_List.marshall(a0.getKSessions(), a1)) + ",\"") + "includes") + "\":") + java_util_List.marshall(a0.getIncludes(), a1)) + ",\"") + "theDefault") + "\":") + java_lang_Boolean.marshall(KBaseModel_boolean_theDefault(a0), a1)) + ",\"") + "scope") + "\":") + java_lang_String.marshall(a0.getScope(), a1)) + ",\"") + "packages") + "\":") + java_util_List.marshall(a0.getPackages(), a1)) + ",\"") + "declarativeAgenda") + "\":") + (a0.getDeclarativeAgenda() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.shared.kmodule.DeclarativeAgendaOption") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getDeclarativeAgenda().name()) + "\"}" : "null")) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_services_shared_kmodule_AssertBehaviorOption == null) {
      org_kie_workbench_common_services_shared_kmodule_AssertBehaviorOption = Marshalling.getMarshaller(AssertBehaviorOption.class);
    }
    if (org_kie_workbench_common_services_shared_kmodule_EventProcessingOption == null) {
      org_kie_workbench_common_services_shared_kmodule_EventProcessingOption = Marshalling.getMarshaller(EventProcessingOption.class);
    }
    if (org_kie_workbench_common_services_shared_kmodule_DeclarativeAgendaOption == null) {
      org_kie_workbench_common_services_shared_kmodule_DeclarativeAgendaOption = Marshalling.getMarshaller(DeclarativeAgendaOption.class);
    }
  }
}