package org.jboss.errai.marshalling.client.api;

import java.util.Map;
import java.util.Set;
import org.guvnor.common.services.project.model.POM;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.services.shared.kmodule.KBaseModel;
import org.kie.workbench.common.services.shared.kmodule.KModuleModel;

public class Marshaller_o_k_w_c_s_s_k_KModuleModel_1_Impl implements GeneratedMarshaller<KModuleModel> {
  private KModuleModel[] EMPTY_ARRAY = new KModuleModel[0];
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<POM> org_guvnor_common_services_project_model_POM = null;
  public KModuleModel[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Map KModuleModel_Map_kBases(KModuleModel instance) /*-{
    return instance.@org.kie.workbench.common.services.shared.kmodule.KModuleModel::kBases;
  }-*/;

  native static void KModuleModel_Map_kBases(KModuleModel instance, Map<String, KBaseModel> value) /*-{
    instance.@org.kie.workbench.common.services.shared.kmodule.KModuleModel::kBases = value;
  }-*/;

  public KModuleModel demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(KModuleModel.class, objId);
    }
    KModuleModel entity = new KModuleModel();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "kBases": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("org.kie.workbench.common.services.shared.kmodule.KBaseModel");
        KModuleModel_Map_kBases(entity, java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "kBasesPath": entity.setKBasesPath(java_lang_String.demarshall(objVal, a1));
        break;
        case "kModulePath": entity.setKModulePath(java_lang_String.demarshall(objVal, a1));
        break;
        case "groupArtifactVersion": entity.setGroupArtifactVersion(org_guvnor_common_services_project_model_POM.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(KModuleModel a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.shared.kmodule.KModuleModel") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "kBases") + "\":") + java_util_Map.marshall(a0.getKBases(), a1)) + ",\"") + "kBasesPath") + "\":") + java_lang_String.marshall(a0.getKBasesPath(), a1)) + ",\"") + "kModulePath") + "\":") + java_lang_String.marshall(a0.getKModulePath(), a1)) + ",\"") + "groupArtifactVersion") + "\":") + org_guvnor_common_services_project_model_POM.marshall(a0.getGroupArtifactVersion(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_guvnor_common_services_project_model_POM == null) {
      org_guvnor_common_services_project_model_POM = Marshalling.getMarshaller(POM.class);
    }
  }
}