package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.guvnor.common.services.project.model.WorkItemHandlerModel;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.services.shared.kmodule.ClockTypeOption;
import org.kie.workbench.common.services.shared.kmodule.KSessionLogger;
import org.kie.workbench.common.services.shared.kmodule.KSessionModel;

public class Marshaller_o_k_w_c_s_s_k_KSessionModel_1_Impl implements GeneratedMarshaller<KSessionModel> {
  private KSessionModel[] EMPTY_ARRAY = new KSessionModel[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<ClockTypeOption> org_kie_workbench_common_services_shared_kmodule_ClockTypeOption = null;
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public KSessionModel[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static boolean KSessionModel_boolean_theDefault(KSessionModel instance) /*-{
    return instance.@org.kie.workbench.common.services.shared.kmodule.KSessionModel::theDefault;
  }-*/;

  native static void KSessionModel_boolean_theDefault(KSessionModel instance, boolean value) /*-{
    instance.@org.kie.workbench.common.services.shared.kmodule.KSessionModel::theDefault = value;
  }-*/;

  native static List KSessionModel_List_workItemHandelerModels(KSessionModel instance) /*-{
    return instance.@org.kie.workbench.common.services.shared.kmodule.KSessionModel::workItemHandelerModels;
  }-*/;

  native static void KSessionModel_List_workItemHandelerModels(KSessionModel instance, List<WorkItemHandlerModel> value) /*-{
    instance.@org.kie.workbench.common.services.shared.kmodule.KSessionModel::workItemHandelerModels = value;
  }-*/;

  public KSessionModel demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(KSessionModel.class, objId);
    }
    KSessionModel entity = new KSessionModel();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
        case "type": entity.setType(java_lang_String.demarshall(objVal, a1));
        break;
        case "clockType": entity.setClockType(objVal.isObject() != null ? Enum.valueOf(ClockTypeOption.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(ClockTypeOption.class, objVal.isString().stringValue()) : null);
        break;
        case "theDefault": KSessionModel_boolean_theDefault(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "scope": entity.setScope(java_lang_String.demarshall(objVal, a1));
        break;
        case "workItemHandelerModels": a1.setAssumedElementType("org.guvnor.common.services.project.model.WorkItemHandlerModel");
        KSessionModel_List_workItemHandelerModels(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "listeners": a1.setAssumedElementType("org.kie.workbench.common.services.shared.kmodule.ListenerModel");
        entity.setListeners(java_util_List.demarshall(objVal, a1));
        break;
        case "logger": entity.setLogger((KSessionLogger) ((ObjectMarshaller) java_lang_Object).demarshall(KSessionLogger.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(KSessionModel a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.shared.kmodule.KSessionModel") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "type") + "\":") + java_lang_String.marshall(a0.getType(), a1)) + ",\"") + "clockType") + "\":") + (a0.getClockType() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.shared.kmodule.ClockTypeOption") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getClockType().name()) + "\"}" : "null")) + ",\"") + "theDefault") + "\":") + java_lang_Boolean.marshall(KSessionModel_boolean_theDefault(a0), a1)) + ",\"") + "scope") + "\":") + java_lang_String.marshall(a0.getScope(), a1)) + ",\"") + "workItemHandelerModels") + "\":") + java_util_List.marshall(a0.getWorkItemHandelerModels(), a1)) + ",\"") + "listeners") + "\":") + java_util_List.marshall(a0.getListeners(), a1)) + ",\"") + "logger") + "\":") + java_lang_Object.marshall(a0.getLogger(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_services_shared_kmodule_ClockTypeOption == null) {
      org_kie_workbench_common_services_shared_kmodule_ClockTypeOption = Marshalling.getMarshaller(ClockTypeOption.class);
    }
  }
}