package org.jboss.errai.marshalling.client.api;

import java.util.Map;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.services.shared.kmodule.QualifierModel;

public class Marshaller_o_k_w_c_s_s_k_QualifierModel_1_Impl implements GeneratedMarshaller<QualifierModel> {
  private QualifierModel[] EMPTY_ARRAY = new QualifierModel[0];
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  public QualifierModel[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static boolean QualifierModel_boolean_simple(QualifierModel instance) /*-{
    return instance.@org.kie.workbench.common.services.shared.kmodule.QualifierModel::simple;
  }-*/;

  native static void QualifierModel_boolean_simple(QualifierModel instance, boolean value) /*-{
    instance.@org.kie.workbench.common.services.shared.kmodule.QualifierModel::simple = value;
  }-*/;

  native static Map QualifierModel_Map_arguments(QualifierModel instance) /*-{
    return instance.@org.kie.workbench.common.services.shared.kmodule.QualifierModel::arguments;
  }-*/;

  native static void QualifierModel_Map_arguments(QualifierModel instance, Map<String, String> value) /*-{
    instance.@org.kie.workbench.common.services.shared.kmodule.QualifierModel::arguments = value;
  }-*/;

  public QualifierModel demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(QualifierModel.class, objId);
    }
    QualifierModel entity = new QualifierModel();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "simple": QualifierModel_boolean_simple(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "type": entity.setType(java_lang_String.demarshall(objVal, a1));
        break;
        case "value": entity.setValue(java_lang_String.demarshall(objVal, a1));
        break;
        case "arguments": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("java.lang.String");
        QualifierModel_Map_arguments(entity, java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
      }
    }
    return entity;
  }

  public String marshall(QualifierModel a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.shared.kmodule.QualifierModel") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "simple") + "\":") + java_lang_Boolean.marshall(QualifierModel_boolean_simple(a0), a1)) + ",\"") + "type") + "\":") + java_lang_String.marshall(a0.getType(), a1)) + ",\"") + "value") + "\":") + java_lang_String.marshall(a0.getValue(), a1)) + ",\"") + "arguments") + "\":") + java_util_Map.marshall(a0.getArguments(), a1)) + "}");
  }

  private void lazyInit() {

  }
}