package org.jboss.errai.marshalling.client.api;

import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;

public class Marshaller_o_o_c_a_s_b_h_HardMediumSoftLongScore_1_Impl implements GeneratedMarshaller<HardMediumSoftLongScore> {
  private HardMediumSoftLongScore[] EMPTY_ARRAY = new HardMediumSoftLongScore[0];
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  public HardMediumSoftLongScore[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public HardMediumSoftLongScore demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(HardMediumSoftLongScore.class, objId);
    }
    final Integer c0 = java_lang_Integer.demarshall(obj.get("initScore"), a1);
    final Long c1 = java_lang_Long.demarshall(obj.get("hardScore"), a1);
    final Long c2 = java_lang_Long.demarshall(obj.get("mediumScore"), a1);
    final Long c3 = java_lang_Long.demarshall(obj.get("softScore"), a1);
    HardMediumSoftLongScore entity = HardMediumSoftLongScore.valueOfUninitialized(c0, c1, c2, c3);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(HardMediumSoftLongScore a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "initScore") + "\":") + java_lang_Integer.marshall(a0.getInitScore(), a1)) + ",\"") + "hardScore") + "\":") + java_lang_Long.marshall(a0.getHardScore(), a1)) + ",\"") + "mediumScore") + "\":") + java_lang_Long.marshall(a0.getMediumScore(), a1)) + ",\"") + "softScore") + "\":") + java_lang_Long.marshall(a0.getSoftScore(), a1)) + "}");
  }

  private void lazyInit() {

  }
}