package org.jboss.errai.marshalling.client.api;

import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;

public class Marshaller_o_o_c_a_s_b_h_HardSoftLongScore_1_Impl implements GeneratedMarshaller<HardSoftLongScore> {
  private HardSoftLongScore[] EMPTY_ARRAY = new HardSoftLongScore[0];
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  public HardSoftLongScore[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public HardSoftLongScore demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(HardSoftLongScore.class, objId);
    }
    final Integer c0 = java_lang_Integer.demarshall(obj.get("initScore"), a1);
    final Long c1 = java_lang_Long.demarshall(obj.get("hardScore"), a1);
    final Long c2 = java_lang_Long.demarshall(obj.get("softScore"), a1);
    HardSoftLongScore entity = HardSoftLongScore.valueOfUninitialized(c0, c1, c2);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(HardSoftLongScore a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "initScore") + "\":") + java_lang_Integer.marshall(a0.getInitScore(), a1)) + ",\"") + "hardScore") + "\":") + java_lang_Long.marshall(a0.getHardScore(), a1)) + ",\"") + "softScore") + "\":") + java_lang_Long.marshall(a0.getSoftScore(), a1)) + "}");
  }

  private void lazyInit() {

  }
}