package org.jboss.errai.marshalling.client.api;

import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;

public class Marshaller_o_o_c_a_s_b_h_HardSoftScore_1_Impl implements GeneratedMarshaller<HardSoftScore> {
  private HardSoftScore[] EMPTY_ARRAY = new HardSoftScore[0];
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  public HardSoftScore[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public HardSoftScore demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(HardSoftScore.class, objId);
    }
    final Integer c0 = java_lang_Integer.demarshall(obj.get("initScore"), a1);
    final Integer c1 = java_lang_Integer.demarshall(obj.get("hardScore"), a1);
    final Integer c2 = java_lang_Integer.demarshall(obj.get("softScore"), a1);
    HardSoftScore entity = HardSoftScore.valueOfUninitialized(c0, c1, c2);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(HardSoftScore a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "initScore") + "\":") + java_lang_Integer.marshall(a0.getInitScore(), a1)) + ",\"") + "hardScore") + "\":") + java_lang_Integer.marshall(a0.getHardScore(), a1)) + ",\"") + "softScore") + "\":") + java_lang_Integer.marshall(a0.getSoftScore(), a1)) + "}");
  }

  private void lazyInit() {

  }
}