package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.optaplanner.workbench.screens.domaineditor.model.ObjectPropertyPathImpl;

public class Marshaller_o_o_w_s_d_m_ObjectPropertyPathImpl_1_Impl implements GeneratedMarshaller<ObjectPropertyPathImpl> {
  private ObjectPropertyPathImpl[] EMPTY_ARRAY = new ObjectPropertyPathImpl[0];
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  public ObjectPropertyPathImpl[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static List ObjectPropertyPathImpl_List_objectPropertyList(ObjectPropertyPathImpl instance) /*-{
    return instance.@org.optaplanner.workbench.screens.domaineditor.model.ObjectPropertyPathImpl::objectPropertyList;
  }-*/;

  native static void ObjectPropertyPathImpl_List_objectPropertyList(ObjectPropertyPathImpl instance, List<ObjectProperty> value) /*-{
    instance.@org.optaplanner.workbench.screens.domaineditor.model.ObjectPropertyPathImpl::objectPropertyList = value;
  }-*/;

  public ObjectPropertyPathImpl demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ObjectPropertyPathImpl.class, objId);
    }
    ObjectPropertyPathImpl entity = new ObjectPropertyPathImpl();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "objectPropertyList": a1.setAssumedElementType("org.kie.workbench.common.services.datamodeller.core.ObjectProperty");
        ObjectPropertyPathImpl_List_objectPropertyList(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "descending": entity.setDescending(java_lang_Boolean.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  native static boolean ObjectPropertyPathImpl_boolean_descending(ObjectPropertyPathImpl instance) /*-{
    return instance.@org.optaplanner.workbench.screens.domaineditor.model.ObjectPropertyPathImpl::descending;
  }-*/;

  native static void ObjectPropertyPathImpl_boolean_descending(ObjectPropertyPathImpl instance, boolean value) /*-{
    instance.@org.optaplanner.workbench.screens.domaineditor.model.ObjectPropertyPathImpl::descending = value;
  }-*/;

  public String marshall(ObjectPropertyPathImpl a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.optaplanner.workbench.screens.domaineditor.model.ObjectPropertyPathImpl") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "objectPropertyList") + "\":") + java_util_List.marshall(ObjectPropertyPathImpl_List_objectPropertyList(a0), a1)) + ",\"") + "descending") + "\":") + java_lang_Boolean.marshall(ObjectPropertyPathImpl_boolean_descending(a0), a1)) + "}");
  }

  private void lazyInit() {

  }
}