package org.jboss.errai.marshalling.client.api;

import java.util.Map;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.plugin.model.Activity;
import org.uberfire.ext.plugin.model.CodeType;
import org.uberfire.ext.plugin.model.Framework;
import org.uberfire.ext.plugin.model.Language;
import org.uberfire.ext.plugin.model.Media;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginContent;
import org.uberfire.ext.plugin.model.PluginSimpleContent;
import org.uberfire.ext.plugin.model.PluginType;

public class Marshaller_o_u_e_p_m_PluginContent_1_Impl implements GeneratedMarshaller<PluginContent> {
  private PluginContent[] EMPTY_ARRAY = new PluginContent[0];
  private Marshaller<Set> java_util_Set = Marshalling.getMarshaller(Set.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  private Marshaller<Language> org_uberfire_ext_plugin_model_Language = null;
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<PluginType> org_uberfire_ext_plugin_model_PluginType = null;
  public PluginContent[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Set PluginContent_Set_mediaLibrary(PluginContent instance) /*-{
    return instance.@org.uberfire.ext.plugin.model.PluginContent::mediaLibrary;
  }-*/;

  native static void PluginContent_Set_mediaLibrary(PluginContent instance, Set<Media> value) /*-{
    instance.@org.uberfire.ext.plugin.model.PluginContent::mediaLibrary = value;
  }-*/;

  native static String PluginSimpleContent_String_template(PluginSimpleContent instance) /*-{
    return instance.@org.uberfire.ext.plugin.model.PluginSimpleContent::template;
  }-*/;

  native static void PluginSimpleContent_String_template(PluginSimpleContent instance, String value) /*-{
    instance.@org.uberfire.ext.plugin.model.PluginSimpleContent::template = value;
  }-*/;

  native static String PluginSimpleContent_String_css(PluginSimpleContent instance) /*-{
    return instance.@org.uberfire.ext.plugin.model.PluginSimpleContent::css;
  }-*/;

  native static void PluginSimpleContent_String_css(PluginSimpleContent instance, String value) /*-{
    instance.@org.uberfire.ext.plugin.model.PluginSimpleContent::css = value;
  }-*/;

  native static Map PluginSimpleContent_Map_codeMap(PluginSimpleContent instance) /*-{
    return instance.@org.uberfire.ext.plugin.model.PluginSimpleContent::codeMap;
  }-*/;

  native static void PluginSimpleContent_Map_codeMap(PluginSimpleContent instance, Map<CodeType, String> value) /*-{
    instance.@org.uberfire.ext.plugin.model.PluginSimpleContent::codeMap = value;
  }-*/;

  native static Set PluginSimpleContent_Set_frameworks(PluginSimpleContent instance) /*-{
    return instance.@org.uberfire.ext.plugin.model.PluginSimpleContent::frameworks;
  }-*/;

  native static void PluginSimpleContent_Set_frameworks(PluginSimpleContent instance, Set<Framework> value) /*-{
    instance.@org.uberfire.ext.plugin.model.PluginSimpleContent::frameworks = value;
  }-*/;

  native static Language PluginSimpleContent_Language_language(PluginSimpleContent instance) /*-{
    return instance.@org.uberfire.ext.plugin.model.PluginSimpleContent::language;
  }-*/;

  native static void PluginSimpleContent_Language_language(PluginSimpleContent instance, Language value) /*-{
    instance.@org.uberfire.ext.plugin.model.PluginSimpleContent::language = value;
  }-*/;

  native static Path Plugin_Path_path(Plugin instance) /*-{
    return instance.@org.uberfire.ext.plugin.model.Plugin::path;
  }-*/;

  native static void Plugin_Path_path(Plugin instance, Path value) /*-{
    instance.@org.uberfire.ext.plugin.model.Plugin::path = value;
  }-*/;

  native static String Activity_String_name(Activity instance) /*-{
    return instance.@org.uberfire.ext.plugin.model.Activity::name;
  }-*/;

  native static void Activity_String_name(Activity instance, String value) /*-{
    instance.@org.uberfire.ext.plugin.model.Activity::name = value;
  }-*/;

  native static PluginType Activity_PluginType_type(Activity instance) /*-{
    return instance.@org.uberfire.ext.plugin.model.Activity::type;
  }-*/;

  native static void Activity_PluginType_type(Activity instance, PluginType value) /*-{
    instance.@org.uberfire.ext.plugin.model.Activity::type = value;
  }-*/;

  public PluginContent demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(PluginContent.class, objId);
    }
    PluginContent entity = new PluginContent();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "mediaLibrary": a1.setAssumedElementType("org.uberfire.ext.plugin.model.Media");
        PluginContent_Set_mediaLibrary(entity, java_util_Set.demarshall(objVal, a1));
        break;
        case "template": PluginSimpleContent_String_template(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "css": PluginSimpleContent_String_css(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "codeMap": a1.setAssumedMapKeyType("org.uberfire.ext.plugin.model.CodeType");
        a1.setAssumedMapValueType("java.lang.String");
        PluginSimpleContent_Map_codeMap(entity, java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "frameworks": a1.setAssumedElementType("org.uberfire.ext.plugin.model.Framework");
        PluginSimpleContent_Set_frameworks(entity, java_util_Set.demarshall(objVal, a1));
        break;
        case "language": PluginSimpleContent_Language_language(entity, objVal.isObject() != null ? Enum.valueOf(Language.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(Language.class, objVal.isString().stringValue()) : null);
        break;
        case "path": Plugin_Path_path(entity, (Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
        case "name": Activity_String_name(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "type": Activity_PluginType_type(entity, objVal.isObject() != null ? Enum.valueOf(PluginType.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(PluginType.class, objVal.isString().stringValue()) : null);
        break;
      }
    }
    return entity;
  }

  public String marshall(PluginContent a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.uberfire.ext.plugin.model.PluginContent") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((("" + ",\"") + "mediaLibrary") + "\":") + java_util_Set.marshall(a0.getMediaLibrary(), a1)) + ",\"") + "template") + "\":") + java_lang_String.marshall(a0.getTemplate(), a1)) + ",\"") + "css") + "\":") + java_lang_String.marshall(a0.getCss(), a1)) + ",\"") + "codeMap") + "\":") + java_util_Map.marshall(a0.getCodeMap(), a1)) + ",\"") + "frameworks") + "\":") + java_util_Set.marshall(PluginSimpleContent_Set_frameworks(a0), a1)) + ",\"") + "language") + "\":") + (a0.getLanguage() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.uberfire.ext.plugin.model.Language") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getLanguage().name()) + "\"}" : "null")) + ",\"") + "path") + "\":") + java_lang_Object.marshall(a0.getPath(), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "type") + "\":") + (a0.getType() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.uberfire.ext.plugin.model.PluginType") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getType().name()) + "\"}" : "null")) + "}");
  }

  private void lazyInit() {
    if (org_uberfire_ext_plugin_model_Language == null) {
      org_uberfire_ext_plugin_model_Language = Marshalling.getMarshaller(Language.class);
    }
    if (org_uberfire_ext_plugin_model_PluginType == null) {
      org_uberfire_ext_plugin_model_PluginType = Marshalling.getMarshaller(PluginType.class);
    }
  }
}