package org.jboss.errai.marshalling.client.api;

import java.util.List;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.uberfire.preferences.shared.impl.validation.ValidationResult;

public class Marshaller_o_u_p_s_i_v_ValidationResult_1_Impl implements GeneratedMarshaller<ValidationResult> {
  private ValidationResult[] EMPTY_ARRAY = new ValidationResult[0];
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public ValidationResult[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ValidationResult demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ValidationResult.class, objId);
    }
    final Boolean c0 = java_lang_Boolean.demarshall(obj.get("valid"), a1);
    a1.setAssumedElementType("java.lang.String");
    final List c1 = java_util_List.demarshall(obj.get("messagesBundleKeys"), a1);
    ValidationResult entity = new ValidationResult(c0, c1);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(ValidationResult a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.uberfire.preferences.shared.impl.validation.ValidationResult") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "valid") + "\":") + java_lang_Boolean.marshall(a0.isValid(), a1)) + ",\"") + "messagesBundleKeys") + "\":") + java_util_List.marshall(a0.getMessagesBundleKeys(), a1)) + "}");
  }

  private void lazyInit() {

  }
}