package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.impl.authz.DefaultAuthorizationEntry;

public class Marshaller_o_u_s_i_a_DefaultAuthorizationEntry_1_Impl implements GeneratedMarshaller<DefaultAuthorizationEntry> {
  private DefaultAuthorizationEntry[] EMPTY_ARRAY = new DefaultAuthorizationEntry[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  public DefaultAuthorizationEntry[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Integer DefaultAuthorizationEntry_Integer_priority(DefaultAuthorizationEntry instance) /*-{
    return instance.@org.uberfire.security.impl.authz.DefaultAuthorizationEntry::priority;
  }-*/;

  native static void DefaultAuthorizationEntry_Integer_priority(DefaultAuthorizationEntry instance, Integer value) /*-{
    instance.@org.uberfire.security.impl.authz.DefaultAuthorizationEntry::priority = value;
  }-*/;

  public DefaultAuthorizationEntry demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DefaultAuthorizationEntry.class, objId);
    }
    DefaultAuthorizationEntry entity = new DefaultAuthorizationEntry();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "description": entity.setDescription(java_lang_String.demarshall(objVal, a1));
        break;
        case "role": entity.setRole((Role) ((ObjectMarshaller) java_lang_Object).demarshall(Role.class, objVal, a1));
        break;
        case "group": entity.setGroup((Group) ((ObjectMarshaller) java_lang_Object).demarshall(Group.class, objVal, a1));
        break;
        case "priority": DefaultAuthorizationEntry_Integer_priority(entity, java_lang_Integer.demarshall(objVal, a1));
        break;
        case "homePerspective": entity.setHomePerspective(java_lang_String.demarshall(objVal, a1));
        break;
        case "permissions": entity.setPermissions((PermissionCollection) ((ObjectMarshaller) java_lang_Object).demarshall(PermissionCollection.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(DefaultAuthorizationEntry a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.uberfire.security.impl.authz.DefaultAuthorizationEntry") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((("" + ",\"") + "description") + "\":") + java_lang_String.marshall(a0.getDescription(), a1)) + ",\"") + "role") + "\":") + java_lang_Object.marshall(a0.getRole(), a1)) + ",\"") + "group") + "\":") + java_lang_Object.marshall(a0.getGroup(), a1)) + ",\"") + "priority") + "\":") + java_lang_Integer.marshall(a0.getPriority(), a1)) + ",\"") + "homePerspective") + "\":") + java_lang_String.marshall(a0.getHomePerspective(), a1)) + ",\"") + "permissions") + "\":") + java_lang_Object.marshall(a0.getPermissions(), a1)) + "}");
  }

  private void lazyInit() {

  }
}