/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.client.home;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.Window;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jbpm.dashboard.renderer.service.DashboardURLBuilder;
import org.kie.workbench.client.resources.i18n.HomePageCommunityConstants;
import org.kie.workbench.common.screens.home.model.HomeModel;
import org.kie.workbench.common.screens.home.model.ModelUtils;
import org.kie.workbench.common.screens.home.model.SectionEntry;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.security.ResourceType;
import org.uberfire.workbench.model.ActivityResourceType;

@ApplicationScoped
public class HomeProducer {
    private HomePageCommunityConstants constants = HomePageCommunityConstants.INSTANCE;
    private HomeModel model;
    @Inject
    private PlaceManager placeManager;

    public void init() {
        String url = GWT.getModuleBaseURL();
        this.model = new HomeModel(this.constants.homeTheKnowledgeLifeCycle());
        this.model.addCarouselEntry(ModelUtils.makeCarouselEntry((String)this.constants.homeDiscover(), (String)this.constants.homeDiscoverCaption(), (String)(url + "/images/HandHome.jpg")));
        this.model.addCarouselEntry(ModelUtils.makeCarouselEntry((String)this.constants.homeAuthor(), (String)this.constants.homeAuthorCaption(), (String)(url + "/images/HandHome.jpg")));
        this.model.addCarouselEntry(ModelUtils.makeCarouselEntry((String)this.constants.homeDeploy(), (String)this.constants.homeDeployCaption(), (String)(url + "/images/HandHome.jpg")));
        this.model.addCarouselEntry(ModelUtils.makeCarouselEntry((String)this.constants.homeWork(), (String)this.constants.homeWorkCaption(), (String)(url + "/images/HandHome.jpg")));
        this.model.addCarouselEntry(ModelUtils.makeCarouselEntry((String)this.constants.homeImprove(), (String)this.constants.homeImproveCaption(), (String)(url + "/images/HandHome.jpg")));
        SectionEntry s1 = ModelUtils.makeSectionEntry((String)this.constants.Authoring());
        s1.addChild(ModelUtils.makeSectionEntry((String)this.constants.Project_Authoring(), () -> this.placeManager.goTo("AuthoringPerspective"), (String)"AuthoringPerspective", (ResourceType)ActivityResourceType.PERSPECTIVE));
        s1.addChild(ModelUtils.makeSectionEntry((String)this.constants.Contributors(), () -> this.placeManager.goTo("ContributorsPerspective"), (String)"ContributorsPerspective", (ResourceType)ActivityResourceType.PERSPECTIVE));
        s1.addChild(ModelUtils.makeSectionEntry((String)this.constants.artifactRepository(), () -> this.placeManager.goTo("GuvnorM2RepoPerspective"), (String)"GuvnorM2RepoPerspective", (ResourceType)ActivityResourceType.PERSPECTIVE));
        s1.addChild(ModelUtils.makeSectionEntry((String)this.constants.Administration(), () -> this.placeManager.goTo("AdministrationPerspective"), (String)"AdministrationPerspective", (ResourceType)ActivityResourceType.PERSPECTIVE));
        SectionEntry s2 = ModelUtils.makeSectionEntry((String)this.constants.Deploy());
        s2.addChild(ModelUtils.makeSectionEntry((String)this.constants.ExecutionServers(), () -> this.placeManager.goTo("ServerManagementPerspective"), (String)"ServerManagementPerspective", (ResourceType)ActivityResourceType.PERSPECTIVE));
        s2.addChild(ModelUtils.makeSectionEntry((String)this.constants.Jobs(), () -> this.placeManager.goTo("Jobs"), (String)"Jobs", (ResourceType)ActivityResourceType.PERSPECTIVE));
        SectionEntry s3 = ModelUtils.makeSectionEntry((String)this.constants.Process_Management());
        s3.addChild(ModelUtils.makeSectionEntry((String)this.constants.Process_Definitions(), () -> this.placeManager.goTo("Process Definitions"), (String)"Process Definitions", (ResourceType)ActivityResourceType.PERSPECTIVE));
        s3.addChild(ModelUtils.makeSectionEntry((String)this.constants.Process_Instances(), () -> this.placeManager.goTo("DataSet Process Instances With Variables"), (String)"DataSet Process Instances With Variables", (ResourceType)ActivityResourceType.PERSPECTIVE));
        SectionEntry s4 = ModelUtils.makeSectionEntry((String)this.constants.Tasks());
        s4.addChild(ModelUtils.makeSectionEntry((String)this.constants.Tasks_List(), () -> this.placeManager.goTo("DataSet Tasks"), (String)"DataSet Tasks", (ResourceType)ActivityResourceType.PERSPECTIVE));
        SectionEntry s5 = ModelUtils.makeSectionEntry((String)this.constants.Dashboards());
        s5.addChild(ModelUtils.makeSectionEntry((String)this.constants.Process_Dashboard(), () -> this.placeManager.goTo("DashboardPerspective"), (String)"DashboardPerspective", (ResourceType)ActivityResourceType.PERSPECTIVE));
        String dashbuilderURL = DashboardURLBuilder.getDashboardURL((String)"/dashbuilder/workspace", (String)"showcase", (String)LocaleInfo.getCurrentLocale().getLocaleName());
        s5.addChild(ModelUtils.makeSectionEntry((String)this.constants.Business_Dashboard(), () -> Window.open((String)dashbuilderURL, (String)"_blank", (String)""), (String)"dashboard.manage"));
        this.model.addSection(s1);
        this.model.addSection(s2);
        this.model.addSection(s3);
        this.model.addSection(s4);
        this.model.addSection(s5);
    }

    @Produces
    public HomeModel getModel() {
        return this.model;
    }
}

