/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.selenium.model.persps;

import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.kie.wb.selenium.model.persps.AbstractPerspective;
import org.kie.wb.selenium.model.persps.authoring.ConflictingRepositoriesModal;
import org.kie.wb.selenium.model.persps.authoring.ImportProjectsScreen;
import org.kie.wb.selenium.model.persps.authoring.ImportRepositoryModal;
import org.kie.wb.selenium.util.Repository;
import org.kie.wb.selenium.util.Waits;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectLibraryPerspective
extends AbstractPerspective {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectLibraryPerspective.class);
    private static final By SPACES_BREADCRUMB = ByJQuery.linkText((String)"Spaces");
    private static final By PROJECT_ACTIONS_BUTTON = By.id((String)"dropdown-space-actions");
    private static final By IMPORT_PROJECT_BUTTON = By.linkText((String)"Import Project");
    private static final By TRY_SAMPLES_BUTTON = By.linkText((String)"Try Samples");
    private static final By DEPLOY_BUTTON = ByJQuery.selector((String)"button:contains('Deploy')");

    @Override
    public void waitForLoaded() {
        this.isDisplayed();
    }

    @Override
    public boolean isDisplayed() {
        return Waits.isElementPresent(SPACES_BREADCRUMB, 60);
    }

    private ImportRepositoryModal importProject() {
        this.click(PROJECT_ACTIONS_BUTTON);
        this.click(IMPORT_PROJECT_BUTTON);
        return ImportRepositoryModal.newInstance();
    }

    private ImportProjectsScreen trySamples() {
        this.click(PROJECT_ACTIONS_BUTTON);
        this.click(TRY_SAMPLES_BUTTON);
        return ImportProjectsScreen.newInstance();
    }

    public void buildAndDeployProject() {
        this.click(DEPLOY_BUTTON);
        this.possiblyOverrideGavConflict();
    }

    public void importStockExampleProject(String ... projects) {
        ImportProjectsScreen importProjectsScreen = this.trySamples();
        importProjectsScreen.selectProjects(projects).ok();
    }

    public void importCustomExampleProject(Repository repo, String ... projects) {
        ImportRepositoryModal modal = this.importProject();
        modal.selectCustomRepository(repo.getUrl());
        ImportProjectsScreen importProjectsScreen = modal.importProjects();
        importProjectsScreen.selectProjects(projects).ok();
    }

    private void possiblyOverrideGavConflict() {
        try {
            ConflictingRepositoriesModal modal = ConflictingRepositoriesModal.newInstance();
            modal.overrideArtifactInMavenRepo();
        }
        catch (NoSuchElementException | TimeoutException ignored) {
            LOG.info("Modal showing GAV conflict didn't appear");
        }
    }
}

