/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.impl.NavigationManagerImpl;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.service.NavigationServices;
import org.guvnor.common.services.shared.config.AppConfigService;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.client.KieWorkbenchEntryPoint;
import org.kie.workbench.client.home.HomeProducer;
import org.kie.workbench.client.navigation.NavTreeDefinitions;
import org.kie.workbench.client.resources.i18n.NavigationConstants;
import org.kie.workbench.common.screens.search.client.menu.SearchMenuBuilder;
import org.kie.workbench.common.screens.social.hp.config.SocialConfigurationService;
import org.kie.workbench.common.services.shared.service.PlaceManagerActivityService;
import org.kie.workbench.common.workbench.client.admin.DefaultAdminPageHelper;
import org.kie.workbench.common.workbench.client.authz.PermissionTreeSetup;
import org.kie.workbench.common.workbench.client.menu.DefaultWorkbenchFeaturesMenusHelper;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.workbench.Workbench;
import org.uberfire.client.workbench.widgets.menu.WorkbenchMenuBarPresenter;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=GwtMockitoTestRunner.class)
public class KieWorkbenchEntryPointTest {
    @Mock
    private AppConfigService appConfigService;
    @Mock
    private HomeProducer homeProducer;
    @Mock
    private SocialConfigurationService socialConfigurationService;
    @Mock
    private DefaultWorkbenchFeaturesMenusHelper menusHelper;
    @Mock
    protected ClientUserSystemManager userSystemManager;
    @Mock
    protected WorkbenchMenuBarPresenter menuBar;
    @Mock
    protected Workbench workbench;
    @Mock
    protected PermissionTreeSetup permissionTreeSetup;
    @Mock
    private PlaceManagerActivityService pmas;
    @Mock
    private ActivityBeansCache activityBeansCache;
    @Mock
    private DefaultAdminPageHelper adminPageHelper;
    @Mock
    protected NavigationConstants navigationConstants;
    @Mock
    protected NavigationServices navigationServices;
    @Mock
    protected SearchMenuBuilder searchMenuBuilder;
    private KieWorkbenchEntryPoint kieWorkbenchEntryPoint;
    private NavTreeDefinitions navTreeDefinitions;
    private NavigationManager navigationManager;

    @Before
    public void setup() {
        this.navTreeDefinitions = new NavTreeDefinitions();
        this.navigationManager = new NavigationManagerImpl((Caller)new CallerMock((Object)this.navigationServices), null, null, null);
        ((PlaceManagerActivityService)Mockito.doNothing().when((Object)this.pmas)).initActivities(Mockito.anyList());
        ((SocialConfigurationService)Mockito.doReturn((Object)Boolean.TRUE).when((Object)this.socialConfigurationService)).isSocialEnable();
        ((ClientUserSystemManager)Mockito.doAnswer(invocationOnMock -> {
            ((Command)invocationOnMock.getArguments()[0]).execute();
            return null;
        }).when((Object)this.userSystemManager)).waitForInitialization((Command)Mockito.any(Command.class));
        CallerMock appConfigServiceCallerMock = new CallerMock((Object)this.appConfigService);
        CallerMock socialConfigurationServiceCallerMock = new CallerMock((Object)this.socialConfigurationService);
        CallerMock pmasCallerMock = new CallerMock((Object)this.pmas);
        this.kieWorkbenchEntryPoint = (KieWorkbenchEntryPoint)Mockito.spy((Object)new KieWorkbenchEntryPoint((Caller)appConfigServiceCallerMock, (Caller)pmasCallerMock, this.activityBeansCache, this.homeProducer, (Caller)socialConfigurationServiceCallerMock, this.menusHelper, this.userSystemManager, this.menuBar, this.workbench, this.permissionTreeSetup, this.adminPageHelper, this.navTreeDefinitions, this.navigationManager, this.searchMenuBuilder));
        ((KieWorkbenchEntryPoint)Mockito.doNothing().when((Object)this.kieWorkbenchEntryPoint)).hideLoadingPopup();
    }

    @Test
    public void initTest() {
        this.kieWorkbenchEntryPoint.init();
        ((Workbench)Mockito.verify((Object)this.workbench)).addStartupBlocker(KieWorkbenchEntryPoint.class);
        ((HomeProducer)Mockito.verify((Object)this.homeProducer)).init();
        ((PermissionTreeSetup)Mockito.verify((Object)this.permissionTreeSetup)).configureTree();
    }

    @Test
    public void setupMenuTest() {
        this.kieWorkbenchEntryPoint.setupMenu();
        ((WorkbenchMenuBarPresenter)Mockito.verify((Object)this.menuBar)).addMenus((Menus)Mockito.any());
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.verify((Object)this.menusHelper)).addRolesMenuItems();
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.verify((Object)this.menusHelper)).addWorkbenchViewModeSwitcherMenuItem();
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.verify((Object)this.menusHelper)).addWorkbenchConfigurationMenuItem();
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.verify((Object)this.menusHelper)).addUtilitiesMenuItems();
        ((Workbench)Mockito.verify((Object)this.workbench)).removeStartupBlocker(KieWorkbenchEntryPoint.class);
    }

    @Test
    public void defaultNavTreeTest() {
        this.kieWorkbenchEntryPoint.setupMenu();
        NavTree navTree = this.navigationManager.getNavTree();
        NavGroup workbench = (NavGroup)navTree.getItemById("wb_group");
        NavGroup home = (NavGroup)navTree.getItemById("wb_group_home");
        NavItem homePage = navTree.getItemById("wb_entry_home");
        NavItem preferences = navTree.getItemById("wb_entry_preferences");
        NavItem timeline = navTree.getItemById("wb_entry_timeline");
        NavItem people = navTree.getItemById("wb_entry_people");
        NavGroup authoring = (NavGroup)navTree.getItemById("wb_group_authoring");
        NavItem library = navTree.getItemById("wb_entry_library");
        NavItem contributors = navTree.getItemById("wb_entry_contributors");
        NavItem artifacts = navTree.getItemById("wb_entry_artifacts");
        NavItem administration = navTree.getItemById("wb_entry_administration");
        NavGroup deploy = (NavGroup)navTree.getItemById("wb_group_deploy");
        NavItem execServers = navTree.getItemById("wb_entry_execution_servers");
        NavItem jobs = navTree.getItemById("wb_entry_jobs");
        NavGroup processMgmt = (NavGroup)navTree.getItemById("wb_group_process_management");
        NavItem processDef = navTree.getItemById("wb_entry_process_definitions");
        NavItem processInst = navTree.getItemById("wb_entry_process_instances");
        NavItem tasks = navTree.getItemById("wb_entry_tasks");
        NavGroup dashboards = (NavGroup)navTree.getItemById("wb_group_dashboards");
        NavItem businessDashboards = navTree.getItemById("wb_entry_process_dashboard");
        NavItem processDashboard = navTree.getItemById("wb_entry_business_dashboards");
        NavGroup extensions = (NavGroup)navTree.getItemById("wb_group_extensions");
        NavItem pluginMgmt = navTree.getItemById("wb_entry_plugin_management");
        NavItem apps = navTree.getItemById("wb_entry_apps");
        NavItem datasets = navTree.getItemById("wb_entry_datasets");
        NavItem datasources = navTree.getItemById("wb_entry_data_sources");
        Assert.assertNotNull((Object)workbench);
        Assert.assertEquals((Object)home.getParent(), (Object)workbench);
        Assert.assertEquals((Object)authoring.getParent(), (Object)workbench);
        Assert.assertEquals((Object)deploy.getParent(), (Object)workbench);
        Assert.assertEquals((Object)tasks.getParent(), (Object)workbench);
        Assert.assertEquals((Object)dashboards.getParent(), (Object)workbench);
        Assert.assertEquals((Object)extensions.getParent(), (Object)workbench);
        Assert.assertNotNull((Object)home);
        Assert.assertNotNull((Object)homePage);
        Assert.assertNotNull((Object)preferences);
        Assert.assertNotNull((Object)timeline);
        Assert.assertNotNull((Object)people);
        Assert.assertEquals((Object)homePage.getParent(), (Object)home);
        Assert.assertEquals((Object)preferences.getParent(), (Object)home);
        Assert.assertEquals((Object)timeline.getParent(), (Object)home);
        Assert.assertEquals((Object)people.getParent(), (Object)home);
        Assert.assertNotNull((Object)library);
        Assert.assertNotNull((Object)authoring);
        Assert.assertNotNull((Object)contributors);
        Assert.assertNotNull((Object)artifacts);
        Assert.assertNotNull((Object)administration);
        Assert.assertEquals((Object)contributors.getParent(), (Object)authoring);
        Assert.assertEquals((Object)artifacts.getParent(), (Object)authoring);
        Assert.assertEquals((Object)administration.getParent(), (Object)authoring);
        Assert.assertEquals((Object)library.getParent(), (Object)authoring);
        Assert.assertNotNull((Object)deploy);
        Assert.assertNotNull((Object)execServers);
        Assert.assertNotNull((Object)jobs);
        Assert.assertEquals((Object)execServers.getParent(), (Object)deploy);
        Assert.assertEquals((Object)jobs.getParent(), (Object)deploy);
        Assert.assertNotNull((Object)processMgmt);
        Assert.assertNotNull((Object)processDef);
        Assert.assertNotNull((Object)processInst);
        Assert.assertEquals((Object)processDef.getParent(), (Object)processMgmt);
        Assert.assertEquals((Object)processInst.getParent(), (Object)processMgmt);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((Object)tasks.getParent(), (Object)workbench);
        Assert.assertNotNull((Object)dashboards);
        Assert.assertNotNull((Object)businessDashboards);
        Assert.assertNotNull((Object)processDashboard);
        Assert.assertEquals((Object)businessDashboards.getParent(), (Object)dashboards);
        Assert.assertEquals((Object)processDashboard.getParent(), (Object)dashboards);
        Assert.assertNotNull((Object)extensions);
        Assert.assertNotNull((Object)pluginMgmt);
        Assert.assertNotNull((Object)apps);
        Assert.assertNotNull((Object)datasets);
        Assert.assertNotNull((Object)datasources);
        Assert.assertEquals((Object)pluginMgmt.getParent(), (Object)extensions);
        Assert.assertEquals((Object)apps.getParent(), (Object)extensions);
        Assert.assertEquals((Object)datasets.getParent(), (Object)extensions);
        Assert.assertEquals((Object)datasources.getParent(), (Object)extensions);
    }
}

