/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.messaging;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.CompletableFutureAssert;
import org.assertj.core.api.MapAssert;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.index.TestUtils;
import org.kie.kogito.index.event.KogitoJobCloudEvent;
import org.kie.kogito.index.event.KogitoProcessCloudEvent;
import org.kie.kogito.index.event.KogitoUserTaskCloudEvent;
import org.kie.kogito.index.messaging.ReactiveMessagingEventConsumer;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceState;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.service.IndexingService;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class ReactiveMessagingEventConsumerTest {
    @Mock
    IndexingService service;
    @InjectMocks
    @Spy
    ReactiveMessagingEventConsumer consumer;

    @Test
    public void testOnProcessInstanceDomainEvent() throws Exception {
        ArgumentCaptor captor = ArgumentCaptor.forClass(ObjectNode.class);
        ((ReactiveMessagingEventConsumer)Mockito.doReturn(CompletableFuture.completedFuture(null)).when((Object)this.consumer)).sendMessage((ObjectNode)captor.capture());
        String processId = "travels";
        String processInstanceId = UUID.randomUUID().toString();
        Message event = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)((KogitoProcessCloudEvent)event.getPayload())).thenReturn((Object)TestUtils.getProcessCloudEvent(processId, processInstanceId, ProcessInstanceState.ACTIVE, null, null, null));
        CompletableFuture future = this.consumer.onProcessInstanceDomainEvent(event).toCompletableFuture();
        future.get(1L, TimeUnit.MINUTES);
        ((Message)Mockito.verify((Object)event)).ack();
        ((CompletableFutureAssert)Assertions.assertThat(future).isDone()).isNotCompletedExceptionally();
        ((MapAssert)JsonAssertions.assertThatJson((Object)((ObjectNode)captor.getValue()).toString()).isObject().containsEntry((Object)"id", (Object)processInstanceId)).containsEntry((Object)"processId", (Object)processId);
    }

    @Test
    public void testOnProcessInstanceDomainEventIndexingException() throws Exception {
        ((ReactiveMessagingEventConsumer)Mockito.doReturn(CompletableFuture.failedFuture(new RuntimeException())).when((Object)this.consumer)).sendMessage((ObjectNode)ArgumentMatchers.any());
        String processId = "travels";
        String processInstanceId = UUID.randomUUID().toString();
        Message event = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)((KogitoProcessCloudEvent)event.getPayload())).thenReturn((Object)TestUtils.getProcessCloudEvent(processId, processInstanceId, ProcessInstanceState.ACTIVE, null, null, null));
        CompletableFuture future = this.consumer.onProcessInstanceDomainEvent(event).toCompletableFuture();
        future.get(1L, TimeUnit.MINUTES);
        ((Message)Mockito.verify((Object)event, (VerificationMode)Mockito.never())).ack();
        ((CompletableFutureAssert)Assertions.assertThat(future).isDone()).isNotCompletedExceptionally();
    }

    @Test
    public void testOnProcessInstanceDomainEventMappingException() throws Exception {
        Message event = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)((KogitoProcessCloudEvent)event.getPayload())).thenReturn((Object)((KogitoProcessCloudEvent)Mockito.mock(KogitoProcessCloudEvent.class)));
        CompletableFuture future = this.consumer.onProcessInstanceDomainEvent(event).toCompletableFuture();
        future.get(1L, TimeUnit.MINUTES);
        ((Message)Mockito.verify((Object)event, (VerificationMode)Mockito.never())).ack();
        ((CompletableFutureAssert)Assertions.assertThat(future).isDone()).isNotCompletedExceptionally();
        ((ReactiveMessagingEventConsumer)Mockito.verify((Object)this.consumer, (VerificationMode)Mockito.never())).sendMessage((ObjectNode)ArgumentMatchers.any());
    }

    @Test
    public void testOnUserTaskInstanceDomainEvent() throws Exception {
        ArgumentCaptor captor = ArgumentCaptor.forClass(ObjectNode.class);
        ((ReactiveMessagingEventConsumer)Mockito.doReturn(CompletableFuture.completedFuture(null)).when((Object)this.consumer)).sendMessage((ObjectNode)captor.capture());
        String taskId = UUID.randomUUID().toString();
        String processId = "travels";
        String processInstanceId = UUID.randomUUID().toString();
        Message event = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)((KogitoUserTaskCloudEvent)event.getPayload())).thenReturn((Object)TestUtils.getUserTaskCloudEvent(taskId, processId, processInstanceId, null, null, "InProgress"));
        CompletableFuture future = this.consumer.onUserTaskInstanceDomainEvent(event).toCompletableFuture();
        future.get(1L, TimeUnit.MINUTES);
        ((Message)Mockito.verify((Object)event)).ack();
        ((CompletableFutureAssert)Assertions.assertThat(future).isDone()).isNotCompletedExceptionally();
        ((MapAssert)JsonAssertions.assertThatJson((Object)((ObjectNode)captor.getValue()).toString()).isObject().containsEntry((Object)"id", (Object)processInstanceId)).containsEntry((Object)"processId", (Object)processId);
    }

    @Test
    public void testOnUserTaskInstanceDomainEventIndexingException() throws Exception {
        ((ReactiveMessagingEventConsumer)Mockito.doReturn(CompletableFuture.failedFuture(new RuntimeException())).when((Object)this.consumer)).sendMessage((ObjectNode)ArgumentMatchers.any());
        String taskId = UUID.randomUUID().toString();
        String processId = "travels";
        String processInstanceId = UUID.randomUUID().toString();
        Message event = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)((KogitoUserTaskCloudEvent)event.getPayload())).thenReturn((Object)TestUtils.getUserTaskCloudEvent(taskId, processId, processInstanceId, null, null, "InProgress"));
        CompletableFuture future = this.consumer.onUserTaskInstanceDomainEvent(event).toCompletableFuture();
        future.get(1L, TimeUnit.MINUTES);
        ((Message)Mockito.verify((Object)event, (VerificationMode)Mockito.never())).ack();
        ((CompletableFutureAssert)Assertions.assertThat(future).isDone()).isNotCompletedExceptionally();
    }

    @Test
    public void testOnUserTaskInstanceDomainEventMappingException() throws Exception {
        Message event = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)((KogitoUserTaskCloudEvent)event.getPayload())).thenReturn((Object)((KogitoUserTaskCloudEvent)Mockito.mock(KogitoUserTaskCloudEvent.class)));
        CompletableFuture future = this.consumer.onUserTaskInstanceDomainEvent(event).toCompletableFuture();
        future.get(1L, TimeUnit.MINUTES);
        ((Message)Mockito.verify((Object)event, (VerificationMode)Mockito.never())).ack();
        ((CompletableFutureAssert)Assertions.assertThat(future).isDone()).isNotCompletedExceptionally();
        ((ReactiveMessagingEventConsumer)Mockito.verify((Object)this.consumer, (VerificationMode)Mockito.never())).sendMessage((ObjectNode)ArgumentMatchers.any());
    }

    @Test
    public void testOnProcessInstanceEvent() throws Exception {
        Message event = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)((KogitoProcessCloudEvent)event.getPayload())).thenReturn((Object)((KogitoProcessCloudEvent)Mockito.mock(KogitoProcessCloudEvent.class)));
        CompletableFuture future = this.consumer.onProcessInstanceEvent(event).toCompletableFuture();
        future.get(1L, TimeUnit.MINUTES);
        ((Message)Mockito.verify((Object)event)).ack();
        ((IndexingService)Mockito.verify((Object)this.service)).indexProcessInstance((ProcessInstance)((KogitoProcessCloudEvent)event.getPayload()).getData());
        ((CompletableFutureAssert)Assertions.assertThat(future).isDone()).isNotCompletedExceptionally();
    }

    @Test
    public void testOnProcessInstanceEventException() throws Exception {
        Message event = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)((KogitoProcessCloudEvent)event.getPayload())).thenReturn((Object)((KogitoProcessCloudEvent)Mockito.mock(KogitoProcessCloudEvent.class)));
        ((IndexingService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.service)).indexProcessInstance((ProcessInstance)ArgumentMatchers.any());
        CompletableFuture future = this.consumer.onProcessInstanceEvent(event).toCompletableFuture();
        future.get(1L, TimeUnit.MINUTES);
        ((Message)Mockito.verify((Object)event, (VerificationMode)Mockito.never())).ack();
        ((IndexingService)Mockito.verify((Object)this.service)).indexProcessInstance((ProcessInstance)((KogitoProcessCloudEvent)event.getPayload()).getData());
        ((CompletableFutureAssert)Assertions.assertThat(future).isDone()).isNotCompletedExceptionally();
    }

    @Test
    public void testOnUserTaskInstanceEvent() throws Exception {
        Message event = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)((KogitoUserTaskCloudEvent)event.getPayload())).thenReturn((Object)((KogitoUserTaskCloudEvent)Mockito.mock(KogitoUserTaskCloudEvent.class)));
        CompletableFuture future = this.consumer.onUserTaskInstanceEvent(event).toCompletableFuture();
        future.get(1L, TimeUnit.MINUTES);
        ((Message)Mockito.verify((Object)event)).ack();
        ((IndexingService)Mockito.verify((Object)this.service)).indexUserTaskInstance((UserTaskInstance)((KogitoUserTaskCloudEvent)event.getPayload()).getData());
        ((CompletableFutureAssert)Assertions.assertThat(future).isDone()).isNotCompletedExceptionally();
    }

    @Test
    public void testOnUserTaskInstanceEventException() throws Exception {
        Message event = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)((KogitoUserTaskCloudEvent)event.getPayload())).thenReturn((Object)((KogitoUserTaskCloudEvent)Mockito.mock(KogitoUserTaskCloudEvent.class)));
        ((IndexingService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.service)).indexUserTaskInstance((UserTaskInstance)ArgumentMatchers.any());
        CompletableFuture future = this.consumer.onUserTaskInstanceEvent(event).toCompletableFuture();
        future.get(1L, TimeUnit.MINUTES);
        ((Message)Mockito.verify((Object)event, (VerificationMode)Mockito.never())).ack();
        ((IndexingService)Mockito.verify((Object)this.service)).indexUserTaskInstance((UserTaskInstance)((KogitoUserTaskCloudEvent)event.getPayload()).getData());
        ((CompletableFutureAssert)Assertions.assertThat(future).isDone()).isNotCompletedExceptionally();
    }

    @Test
    public void testOnJobEvent() throws Exception {
        Message event = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)((KogitoJobCloudEvent)event.getPayload())).thenReturn((Object)((KogitoJobCloudEvent)Mockito.mock(KogitoJobCloudEvent.class)));
        CompletableFuture future = this.consumer.onJobEvent(event).toCompletableFuture();
        future.get(1L, TimeUnit.MINUTES);
        ((Message)Mockito.verify((Object)event)).ack();
        ((IndexingService)Mockito.verify((Object)this.service)).indexJob((Job)((KogitoJobCloudEvent)event.getPayload()).getData());
        ((CompletableFutureAssert)Assertions.assertThat(future).isDone()).isNotCompletedExceptionally();
    }

    @Test
    public void testOnJobEventException() throws Exception {
        Message event = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)((KogitoJobCloudEvent)event.getPayload())).thenReturn((Object)((KogitoJobCloudEvent)Mockito.mock(KogitoJobCloudEvent.class)));
        ((IndexingService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.service)).indexJob((Job)ArgumentMatchers.any());
        CompletableFuture future = this.consumer.onJobEvent(event).toCompletableFuture();
        future.get(1L, TimeUnit.MINUTES);
        ((Message)Mockito.verify((Object)event, (VerificationMode)Mockito.never())).ack();
        ((IndexingService)Mockito.verify((Object)this.service)).indexJob((Job)((KogitoJobCloudEvent)event.getPayload()).getData());
        ((CompletableFutureAssert)Assertions.assertThat(future).isDone()).isNotCompletedExceptionally();
    }
}

