/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql;

import com.fasterxml.jackson.databind.JsonNode;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPropertyDataFetcher
implements DataFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonPropertyDataFetcher.class);

    public Object get(DataFetchingEnvironment environment) {
        String property = environment.getField().getName();
        Object source = environment.getSource();
        if (source instanceof JsonNode) {
            JsonNode jsonObject = (JsonNode)source;
            try {
                JsonNode value = jsonObject.findValue(property);
                if (value == null) {
                    return null;
                }
                switch (value.getNodeType()) {
                    case OBJECT: 
                    case POJO: 
                    case ARRAY: {
                        return value;
                    }
                    case NUMBER: {
                        return value.numberValue();
                    }
                    case BOOLEAN: {
                        return value.asBoolean();
                    }
                    case STRING: {
                        return value.asText();
                    }
                }
                return null;
            }
            catch (Exception ex) {
                LOGGER.warn(ex.getMessage());
                return null;
            }
        }
        return null;
    }
}

