/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql.query;

import graphql.schema.GraphQLScalarType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.index.DataIndexStorageService;
import org.kie.kogito.index.graphql.GraphQLScalarTypeProducer;
import org.kie.kogito.index.graphql.GraphQLSchemaManager;
import org.kie.kogito.index.graphql.query.GraphQLQueryParser;
import org.kie.kogito.index.graphql.query.GraphQLQueryParserRegistry;
import org.kie.kogito.persistence.api.query.AttributeFilter;
import org.kie.kogito.persistence.api.query.FilterCondition;
import org.kie.kogito.persistence.api.query.QueryFilterFactory;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class GraphQLQueryMapperTest {
    @InjectMocks
    GraphQLSchemaManager manager;
    @Mock
    DataIndexStorageService cacheService;
    @Spy
    GraphQLScalarType qlDateTimeScalarType = new GraphQLScalarTypeProducer().dateTimeScalar();
    GraphQLQueryParser processInstanceParser;

    private static void assertAttributeFilter(String attribute, FilterCondition condition, AttributeFilter filter, String ... values) {
        Assertions.assertThat((Comparable)filter.getCondition()).isEqualTo((Object)condition);
        Assertions.assertThat((String)filter.getAttribute()).isEqualTo(attribute);
        if (values.length == 1) {
            Assertions.assertThat((Object)filter.getValue()).isEqualTo((Object)values[0]);
        } else {
            Assertions.assertThat((Object)filter.getValue()).asList().containsExactly((Object[])values);
        }
    }

    @BeforeEach
    public void setup() {
        this.manager.setup();
        this.processInstanceParser = GraphQLQueryParserRegistry.get().getParser("ProcessInstanceArgument");
    }

    @Test
    public void testQuery() {
        HashMap<String, List<Map>> where = new HashMap<String, List<Map>>();
        HashMap id = new HashMap();
        HashMap<String, Object> idValues = new HashMap<String, Object>();
        idValues.put("in", Arrays.asList("adasdasd", "bla"));
        idValues.put("isNull", false);
        id.put("id", idValues);
        HashMap<String, Map<String, Integer>> state = new HashMap<String, Map<String, Integer>>();
        state.put("state", Collections.singletonMap("equal", 1));
        where.put("and", Arrays.asList(id, state));
        List filters = this.processInstanceParser.apply(where);
        Assertions.assertThat((List)filters).hasSize(1);
        AttributeFilter filter = (AttributeFilter)filters.get(0);
        Assertions.assertThat((Comparable)filter.getCondition()).isEqualTo((Object)FilterCondition.AND);
        ((AbstractListAssert)Assertions.assertThat((Object)filter.getValue()).asList().hasSize(3)).containsExactly(new Object[]{QueryFilterFactory.in((String)"id", Arrays.asList("adasdasd", "bla")), QueryFilterFactory.notNull((String)"id"), QueryFilterFactory.equalTo((String)"state", (Object)1)});
    }

    @Test
    public void testDatesQuery() {
        HashMap<String, Map<String, Object>> where = new HashMap<String, Map<String, Object>>();
        where.put("start", Collections.singletonMap("equal", "2019-01-01"));
        HashMap<String, String> between = new HashMap<String, String>();
        between.put("from", "2019-01-01");
        between.put("to", "2020-01-01");
        where.put("end", Collections.singletonMap("between", between));
        List filters = this.processInstanceParser.apply(where);
        Assertions.assertThat((List)filters).hasSize(2);
        GraphQLQueryMapperTest.assertAttributeFilter("start", FilterCondition.EQUAL, (AttributeFilter)filters.get(0), "2019-01-01");
        GraphQLQueryMapperTest.assertAttributeFilter("end", FilterCondition.BETWEEN, (AttributeFilter)filters.get(1), "2019-01-01", "2020-01-01");
    }

    @Test
    public void testNodesQuery() {
        HashMap<String, Map<String, Map<String, String>>> where = new HashMap<String, Map<String, Map<String, String>>>();
        where.put("nodes", Collections.singletonMap("name", Collections.singletonMap("equal", "StartNode")));
        List filters = this.processInstanceParser.apply(where);
        Assertions.assertThat((List)filters).hasSize(1);
        GraphQLQueryMapperTest.assertAttributeFilter("nodes.name", FilterCondition.EQUAL, (AttributeFilter)filters.get(0), "StartNode");
    }

    @Test
    public void testOrQuery() {
        HashMap<String, List<Map>> where = new HashMap<String, List<Map>>();
        HashMap id = new HashMap();
        HashMap<String, List<String>> idValues = new HashMap<String, List<String>>();
        idValues.put("in", Arrays.asList("travels"));
        id.put("processName", idValues);
        HashMap<String, Map<String, Boolean>> state = new HashMap<String, Map<String, Boolean>>();
        state.put("rootProcessId", Collections.singletonMap("isNull", true));
        HashMap<String, Object> roles = new HashMap<String, Object>();
        roles.put("contains", "admin");
        roles.put("containsAll", Arrays.asList("kogito", "admin"));
        roles.put("containsAny", Arrays.asList("admin", "kogito"));
        where.put("or", Arrays.asList(id, state, Collections.singletonMap("roles", roles)));
        List filters = this.processInstanceParser.apply(where);
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)filters).hasSize(1)).first()).extracting(f -> f.getValue()).asList().containsExactly(new Object[]{QueryFilterFactory.in((String)"processName", Arrays.asList("travels")), QueryFilterFactory.isNull((String)"rootProcessId"), QueryFilterFactory.contains((String)"roles", (String)"admin"), QueryFilterFactory.containsAll((String)"roles", Arrays.asList("kogito", "admin")), QueryFilterFactory.containsAny((String)"roles", Arrays.asList("admin", "kogito"))});
    }
}

