/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.kie.kogito.index.TestUtils;
import org.kie.kogito.index.json.JsonUtils;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceState;
import org.kie.kogito.index.model.UserTaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphQLUtils.class);
    private static final Map<Class, String> QUERY_FIELDS = new HashMap<Class, String>();
    private static final Map<String, String> QUERIES = new HashMap<String, String>();

    public static String getProcessInstanceById(String id) {
        return GraphQLUtils.getProcessInstanceQuery("ProcessInstanceById", id);
    }

    public static String getProcessInstanceByIdAndState(String id, ProcessInstanceState state) {
        return GraphQLUtils.getProcessInstanceQuery("ProcessInstanceByIdAndState", id, state.name());
    }

    public static String getProcessInstanceByIdAndStart(String id, String start) {
        return GraphQLUtils.getProcessInstanceQuery("ProcessInstanceByIdAndStart", id, start);
    }

    public static String getProcessInstanceByIdAndProcessId(String id, String processId) {
        return GraphQLUtils.getProcessInstanceQuery("ProcessInstanceByIdAndProcessId", id, processId);
    }

    public static String getProcessInstanceByIdAndParentProcessInstanceId(String id, String parentProcessInstanceId) {
        return GraphQLUtils.getProcessInstanceQuery("ProcessInstanceByIdAndParentProcessInstanceId", id, parentProcessInstanceId);
    }

    public static String getProcessInstanceByParentProcessInstanceId(String parentProcessInstanceId) {
        return GraphQLUtils.getProcessInstanceQuery("ProcessInstanceByParentProcessInstanceId", parentProcessInstanceId);
    }

    public static String getProcessInstanceByIdAndNullParentProcessInstanceId(String id, Boolean isNull) {
        return GraphQLUtils.getProcessInstanceQuery("ProcessInstanceByIdAndNullParentProcessInstanceId", id, isNull.toString());
    }

    public static String getProcessInstanceByIdAndNullRootProcessInstanceId(String id, Boolean isNull) {
        return GraphQLUtils.getProcessInstanceQuery("ProcessInstanceByIdAndNullRootProcessInstanceId", id, isNull.toString());
    }

    public static String getProcessInstanceByRootProcessInstanceId(String rootProcessInstanceId) {
        return GraphQLUtils.getProcessInstanceQuery("ProcessInstanceByRootProcessInstanceId", rootProcessInstanceId);
    }

    public static String getProcessInstanceByIdAndErrorNode(String id, String nodeDefinitionId) {
        return GraphQLUtils.getProcessInstanceQuery("ProcessInstanceByIdAndErrorNode", id, nodeDefinitionId);
    }

    public static String getProcessInstanceByIdAndAddon(String id, String addon) {
        return GraphQLUtils.getProcessInstanceQuery("ProcessInstanceByIdAndAddon", id, addon);
    }

    public static String getProcessInstanceByIdAndMilestoneName(String id, String milestone) {
        return GraphQLUtils.getProcessInstanceQuery("ProcessInstanceByIdAndMilestoneName", id, milestone);
    }

    public static String getProcessInstanceByIdAndMilestoneStatus(String id, String status) {
        return GraphQLUtils.getProcessInstanceQuery("ProcessInstanceByIdAndMilestoneStatus", id, status);
    }

    public static String getUserTaskInstanceById(String id) {
        return GraphQLUtils.getUserTaskInstanceQuery("UserTaskInstanceById", id);
    }

    public static String getUserTaskInstanceByIdAndActualOwner(String id, String actualOwner) {
        return GraphQLUtils.getUserTaskInstanceQuery("UserTaskInstanceByIdAndActualOwner", id, actualOwner);
    }

    public static String getUserTaskInstanceByIdAndState(String id, String state) {
        return GraphQLUtils.getUserTaskInstanceQuery("UserTaskInstanceByIdAndState", id, state);
    }

    public static String getUserTaskInstanceByIdAndStarted(String id, String started) {
        return GraphQLUtils.getUserTaskInstanceQuery("UserTaskInstanceByIdAndStarted", id, started);
    }

    public static String getUserTaskInstanceByIdAndCompleted(String id, String completed) {
        return GraphQLUtils.getUserTaskInstanceQuery("UserTaskInstanceByIdAndCompleted", id, completed);
    }

    public static String getUserTaskInstanceByIdAndPotentialGroups(String id, List<String> potentialGroups) throws Exception {
        return GraphQLUtils.getUserTaskInstanceWithArray("UserTaskInstanceByIdAndPotentialGroups", potentialGroups, "potentialGroups", id);
    }

    public static String getUserTaskInstanceByIdAndPotentialUsers(String id, List<String> potentialUsers) throws Exception {
        return GraphQLUtils.getUserTaskInstanceWithArray("UserTaskInstanceByIdAndPotentialUsers", potentialUsers, "potentialUsers", id);
    }

    public static String getJobById(String id) {
        return GraphQLUtils.getJobQuery("JobById", id);
    }

    public static String getTravelsByUserTaskId(String id) {
        return GraphQLUtils.getQuery("TravelsByUserTaskId", id);
    }

    public static String getTravelsByProcessInstanceId(String id) {
        return GraphQLUtils.getQuery("TravelsByProcessInstanceId", id);
    }

    public static String getTravelsByProcessInstanceIdAndTravellerFirstName(String id, String name) {
        return GraphQLUtils.getQuery("TravelsByProcessInstanceIdAndTravellerFirstName", id, name);
    }

    public static String getDealsByTaskId(String id) {
        return GraphQLUtils.getQuery("DealsByTaskId", id);
    }

    private static String getUserTaskInstanceWithArray(String query, List<String> values, String variable, String ... args) throws Exception {
        String json = GraphQLUtils.getUserTaskInstanceQuery(query, args);
        ObjectNode jsonNode = (ObjectNode)JsonUtils.getObjectMapper().readTree(json);
        ArrayNode pg = (ArrayNode)jsonNode.get("variables").get(variable);
        values.forEach(g -> pg.add(g));
        return jsonNode.toString();
    }

    private static String getQuery(String name, String ... args) {
        return String.format(QUERIES.get(name), args);
    }

    private static String getProcessInstanceQuery(String name, String ... args) {
        return GraphQLUtils.getQuery(name, ProcessInstance.class, args);
    }

    private static String getUserTaskInstanceQuery(String name, String ... args) {
        return GraphQLUtils.getQuery(name, UserTaskInstance.class, args);
    }

    private static String getJobQuery(String name, String ... args) {
        return GraphQLUtils.getQuery(name, Job.class, args);
    }

    private static String getQuery(String name, Class clazz, String ... args) {
        return String.format(QUERIES.get(name), ArrayUtils.insert((int)0, (Object[])args, (Object[])new String[]{QUERY_FIELDS.get(clazz)}));
    }

    private static Stream<Field> getAllFieldsList(Class clazz) {
        return FieldUtils.getAllFieldsList((Class)clazz).stream().filter(f -> GraphQLUtils.getJacocoPredicate().test((Field)f));
    }

    private static Function<Field, String> getFieldName() {
        return field -> {
            if (field.getGenericType() instanceof ParameterizedType) {
                ParameterizedType genericType = (ParameterizedType)field.getGenericType();
                StringBuilder builder = new StringBuilder();
                builder.append(Arrays.stream(genericType.getActualTypeArguments()).filter(type -> type.getTypeName().startsWith("org.kie.kogito.index.model")).flatMap(type -> {
                    try {
                        return GraphQLUtils.getAllFieldsList(Class.forName(type.getTypeName()));
                    }
                    catch (Exception ex) {
                        return Stream.empty();
                    }
                }).map(f -> GraphQLUtils.getFieldName().apply((Field)f)).collect(Collectors.joining(", ")));
                if (builder.length() > 0) {
                    return field.getName() + " { " + builder.toString() + " }";
                }
            }
            if (field.getType().getName().startsWith("org.kie.kogito.index.model")) {
                return field.getName() + " { " + GraphQLUtils.getAllFieldsList(field.getType()).map(f -> GraphQLUtils.getFieldName().apply((Field)f)).collect(Collectors.joining(", ")) + " }";
            }
            return field.getName();
        };
    }

    private static Predicate<Field> getJacocoPredicate() {
        return field -> !field.getName().equals("$jacocoData");
    }

    static {
        QUERY_FIELDS.put(UserTaskInstance.class, GraphQLUtils.getAllFieldsList(UserTaskInstance.class).map(GraphQLUtils.getFieldName()).collect(Collectors.joining(", ")));
        QUERY_FIELDS.put(ProcessInstance.class, GraphQLUtils.getAllFieldsList(ProcessInstance.class).map(GraphQLUtils.getFieldName()).collect(Collectors.joining(", ")));
        QUERY_FIELDS.put(Job.class, GraphQLUtils.getAllFieldsList(Job.class).map(GraphQLUtils.getFieldName()).collect(Collectors.joining(", ")));
        QUERY_FIELDS.computeIfPresent(ProcessInstance.class, (k, v) -> v + ", serviceUrl");
        QUERY_FIELDS.computeIfPresent(ProcessInstance.class, (k, v) -> v + ", childProcessInstances { id, processName }");
        QUERY_FIELDS.computeIfPresent(ProcessInstance.class, (k, v) -> v + ", parentProcessInstance { id, processName }");
        try {
            JsonNode node = JsonUtils.getObjectMapper().readTree(TestUtils.readFileContent("graphql_queries.json"));
            Iterator it = node.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                QUERIES.put((String)entry.getKey(), ((JsonNode)entry.getValue()).toString());
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to parse graphql_queries.json file: {}", (Object)ex.getMessage(), (Object)ex);
            throw new RuntimeException(ex);
        }
    }
}

