/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql.query;

import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.Map;
import java.util.function.Consumer;
import org.kie.kogito.index.graphql.query.AbstractInputObjectTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLInputObjectTypeMapper
extends AbstractInputObjectTypeMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphQLInputObjectTypeMapper.class);
    private static final String ARGUMENT = "Argument";
    private boolean mapOperators;

    public GraphQLInputObjectTypeMapper(GraphQLSchema schema, Map<String, GraphQLType> additionalTypes, boolean mapOperators) {
        super(schema, additionalTypes);
        this.mapOperators = mapOperators;
    }

    public GraphQLInputObjectTypeMapper(GraphQLSchema schema, Map<String, GraphQLType> additionalTypes) {
        this(schema, additionalTypes, true);
    }

    @Override
    protected String getTypeName(GraphQLObjectType type) {
        return type.getName() + ARGUMENT;
    }

    @Override
    protected Consumer<GraphQLInputObjectType.Builder> build(GraphQLObjectType domain) {
        return builder -> {
            if (this.mapOperators) {
                builder.field(GraphQLInputObjectField.newInputObjectField().name("and").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)new GraphQLTypeReference(this.getTypeName(domain))))));
                builder.field(GraphQLInputObjectField.newInputObjectField().name("or").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)new GraphQLTypeReference(this.getTypeName(domain))))));
            }
            domain.getFieldDefinitions().forEach(field -> {
                LOGGER.debug("GraphQL mapping field: {}", field);
                if ("metadata".equals(field.getName())) {
                    builder.field(GraphQLInputObjectField.newInputObjectField().name("metadata").type((GraphQLInputType)new GraphQLTypeReference("KogitoMetadataArgument"))).build();
                } else if ("id".equals(field.getName())) {
                    builder.field(GraphQLInputObjectField.newInputObjectField().name("id").type((GraphQLInputType)new GraphQLTypeReference("IdArgument"))).build();
                } else {
                    this.newField((GraphQLInputObjectType.Builder)builder, (GraphQLFieldDefinition)field, this.getInputTypeByField((GraphQLFieldDefinition)field));
                }
            });
        };
    }

    private GraphQLInputType getInputTypeByField(GraphQLFieldDefinition field) {
        String name;
        switch (name = ((GraphQLNamedType)field.getType()).getName()) {
            case "Int": {
                return this.getInputObjectType("NumericArgument");
            }
            case "String": {
                return this.getInputObjectType("StringArgument");
            }
            case "Boolean": {
                return this.getInputObjectType("BooleanArgument");
            }
            case "DateTime": {
                return this.getInputObjectType("DateArgument");
            }
        }
        String typeName = name + ARGUMENT;
        GraphQLType schemaType = this.getExistingType(typeName);
        if (schemaType == null) {
            GraphQLInputObjectType type = new GraphQLInputObjectTypeMapper(this.getSchema(), this.getAdditionalTypes(), false).apply((GraphQLObjectType)this.getAdditionalTypes().get(name));
            this.getAdditionalTypes().put(typeName, (GraphQLType)type);
            return type;
        }
        return (GraphQLInputType)schemaType;
    }

    private GraphQLType getExistingType(String typeName) {
        GraphQLType schemaType = this.getSchema().getType(typeName);
        return schemaType == null ? this.getAdditionalTypes().get(typeName) : schemaType;
    }

    private void newField(GraphQLInputObjectType.Builder builder, GraphQLFieldDefinition field, GraphQLInputType type) {
        builder.field(GraphQLInputObjectField.newInputObjectField().name(field.getName()).type(type));
    }
}

