/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.config.EncoderConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Collection;
import java.util.UUID;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.InfinispanServerTestResource;
import org.kie.kogito.index.TestUtils;
import org.kie.kogito.index.event.KogitoCloudEvent;
import org.kie.kogito.index.infinispan.protostream.ProtobufService;
import org.kie.kogito.index.messaging.ReactiveMessagingEventConsumer;
import org.kie.kogito.index.model.ProcessInstanceState;

@QuarkusTest
@QuarkusTestResource(value=InfinispanServerTestResource.class)
public class IndexingServiceTest {
    @Inject
    ReactiveMessagingEventConsumer consumer;
    @Inject
    ProtobufService protobufService;

    @BeforeAll
    public static void setup() {
        RestAssured.config = RestAssured.config().encoderConfig(EncoderConfig.encoderConfig().appendDefaultContentCharsetToContentTypeIfUndefined(false));
    }

    @Test
    public void testAddBrokenProtoFile() {
        try {
            this.protobufService.registerProtoBufferType(this.getBrokenProtoBufferFile());
            Assertions.fail((String)"Registering broken proto file should fail");
        }
        catch (Exception ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo((Object)"Failed to resolve type of field \"travels.traveller\". Type not found : stringa");
        }
    }

    @Test
    public void testAddProtoFileMissingModel() {
        try {
            this.protobufService.registerProtoBufferType(this.getProtoBufferFileWithoutModel());
            Assertions.fail((String)"Registering broken proto file should fail");
        }
        catch (Exception ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo((Object)"Missing marker for main message type in proto file, please add option kogito_model=\"messagename\"");
        }
    }

    @Test
    public void testAddProtoFileMissingId() {
        try {
            this.protobufService.registerProtoBufferType(this.getProtoBufferFileWithoutId());
            Assertions.fail((String)"Registering broken proto file should fail");
        }
        catch (Exception ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo((Object)"Missing marker for process id in proto file, please add option kogito_id=\"processid\"");
        }
    }

    @Test
    public void testAddProtoFileMissingModelType() {
        try {
            this.protobufService.registerProtoBufferType(this.getProtoBufferFileWithoutModelType());
            Assertions.fail((String)"Registering broken proto file should fail");
        }
        catch (Exception ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo((Object)"Could not find message with name: traveller in proto file, e, please review option kogito_model");
        }
    }

    @Test
    public void testAddProtoFileTwice() throws Exception {
        this.protobufService.registerProtoBufferType(this.getProtoBufferFileV1());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{Game{ player, id, name, processInstances { id } } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Game", CoreMatchers.isA(Collection.class), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ProcessInstances{ id, processId, rootProcessId, rootProcessInstanceId, parentProcessInstanceId } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.ProcessInstances", CoreMatchers.isA(Collection.class), new Object[0]);
        this.protobufService.registerProtoBufferType(this.getProtoBufferFileV2());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{Game{ id, name, company, processInstances { id } } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Game", CoreMatchers.isA(Collection.class), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ProcessInstances{ id, processId, rootProcessId, rootProcessInstanceId, parentProcessInstanceId } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.ProcessInstances", CoreMatchers.isA(Collection.class), new Object[0]);
    }

    @Test
    public void testAddProtoFile() throws Exception {
        String processId = "travels";
        String subProcessId = processId + "_sub";
        String processInstanceId = UUID.randomUUID().toString();
        String subProcessInstanceId = UUID.randomUUID().toString();
        this.protobufService.registerProtoBufferType(TestUtils.getTravelsProtoBufferFile());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{Travels{ id } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels", CoreMatchers.isA(Collection.class), new Object[0]);
        KogitoCloudEvent startEvent = TestUtils.getTravelsCloudEvent(processId, processInstanceId, "ProcessInstanceEvent", ProcessInstanceState.ACTIVE, null, null);
        this.consumer.onProcessInstanceEvent(startEvent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ProcessInstances(filter: { id: \\\"" + processInstanceId + "\\\", state: ACTIVE }){ id, processId, rootProcessId, rootProcessInstanceId, parentProcessInstanceId } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.ProcessInstances[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.ProcessInstances[0].processId", CoreMatchers.is((Object)processId), new Object[0])).body("data.ProcessInstances[0].rootProcessId", Matchers.isEmptyOrNullString(), new Object[0])).body("data.ProcessInstances[0].rootProcessInstanceId", Matchers.isEmptyOrNullString(), new Object[0])).body("data.ProcessInstances[0].parentProcessInstanceId", Matchers.isEmptyOrNullString(), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{Travels(query: \\\"from org.acme.travels.travels.Travels t where t.traveller.firstName:'ma*' and t.processInstances.id:'" + processInstanceId + "'\\\"){ flight { flightNumber }, hotel { name }, traveller { firstName }, processInstances { id, processId, rootProcessId, rootProcessInstanceId, parentProcessInstanceId } } }\"}").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels[0].processInstances.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Travels[0].processInstances[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].processInstances[0].processId", CoreMatchers.is((Object)processId), new Object[0])).body("data.Travels[0].processInstances[0].rootProcessId", Matchers.isEmptyOrNullString(), new Object[0])).body("data.Travels[0].processInstances[0].rootProcessInstanceId", Matchers.isEmptyOrNullString(), new Object[0])).body("data.Travels[0].processInstances[0].parentProcessInstanceId", Matchers.isEmptyOrNullString(), new Object[0])).body("data.Travels[0].traveller.firstName", CoreMatchers.is((Object)"Maciej"), new Object[0])).body("data.Travels[0].hotel.name", CoreMatchers.is((Object)"Meriton"), new Object[0])).body("data.Travels[0].flight.flightNumber", CoreMatchers.is((Object)"MX555"), new Object[0]);
        KogitoCloudEvent subProcessStartEvent = TestUtils.getTravelsCloudEvent(subProcessId, subProcessInstanceId, "ProcessInstanceEvent", ProcessInstanceState.ACTIVE, processInstanceId, processId);
        this.consumer.onProcessInstanceEvent(subProcessStartEvent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ProcessInstances(filter: { id: \\\"" + subProcessInstanceId + "\\\", state: ACTIVE }){ id, processId, rootProcessId, rootProcessInstanceId, parentProcessInstanceId } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.ProcessInstances[0].id", CoreMatchers.is((Object)subProcessInstanceId), new Object[0])).body("data.ProcessInstances[0].processId", CoreMatchers.is((Object)subProcessId), new Object[0])).body("data.ProcessInstances[0].rootProcessId", CoreMatchers.is((Object)processId), new Object[0])).body("data.ProcessInstances[0].rootProcessInstanceId", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.ProcessInstances[0].parentProcessInstanceId", CoreMatchers.is((Object)processInstanceId), new Object[0]);
        KogitoCloudEvent endEvent = TestUtils.getTravelsCloudEvent(processId, processInstanceId, "ProcessInstanceEvent", ProcessInstanceState.COMPLETED, null, null);
        this.consumer.onProcessInstanceEvent(endEvent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ProcessInstances(filter: { id: \\\"" + processInstanceId + "\\\", state: COMPLETED }){ id, processId, rootProcessId, rootProcessInstanceId, parentProcessInstanceId } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.ProcessInstances[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.ProcessInstances[0].processId", CoreMatchers.is((Object)processId), new Object[0])).body("data.ProcessInstances[0].rootProcessId", Matchers.isEmptyOrNullString(), new Object[0])).body("data.ProcessInstances[0].rootProcessInstanceId", Matchers.isEmptyOrNullString(), new Object[0])).body("data.ProcessInstances[0].parentProcessInstanceId", Matchers.isEmptyOrNullString(), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{Travels(query: \\\"from org.acme.travels.travels.Travels t where t.traveller.firstName:'ma*' and t.processInstances.id:'" + subProcessInstanceId + "'\\\"){ flight { flightNumber, arrival, departure }, hotel { name }, traveller { firstName }, processInstances { id, processId, rootProcessId, rootProcessInstanceId, parentProcessInstanceId } } }\"}").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels[0].processInstances.size()", CoreMatchers.is((Object)2), new Object[0])).body("data.Travels[0].processInstances[1].id", CoreMatchers.is((Object)subProcessInstanceId), new Object[0])).body("data.Travels[0].processInstances[1].processId", CoreMatchers.is((Object)subProcessId), new Object[0])).body("data.Travels[0].processInstances[1].rootProcessId", CoreMatchers.is((Object)processId), new Object[0])).body("data.Travels[0].processInstances[1].rootProcessInstanceId", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].processInstances[1].parentProcessInstanceId", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].traveller.firstName", CoreMatchers.is((Object)"Maciej"), new Object[0])).body("data.Travels[0].hotel.name", CoreMatchers.is((Object)"Meriton"), new Object[0])).body("data.Travels[0].flight.flightNumber", CoreMatchers.is((Object)"MX555"), new Object[0])).body("data.Travels[0].flight.arrival", CoreMatchers.is((Object)"2019-08-20T22:12:57.340Z"), new Object[0])).body("data.Travels[0].flight.departure", CoreMatchers.is((Object)"2019-08-20T07:12:57.340Z"), new Object[0]);
    }

    private String getProtoBufferFileWithoutModelType() {
        return "   option kogito_id=\"travels\";\n   option kogito_model=\"traveller\";\nmessage travels {\n   optional string traveller = 1;\n   optional string hotel = 2;\n   optional string flight = 3;\n}\n\n";
    }

    private String getProtoBufferFileWithoutId() {
        return "   option kogito_model=\"travels\";\nmessage travels {\n   optional string traveller = 1;\n   optional string hotel = 2;\n   optional string flight = 3;\n}\n\n";
    }

    private String getProtoBufferFileWithoutModel() {
        return "   option kogito_id=\"travels\";\nmessage travels {\n   optional string traveller = 1;\n   optional string hotel = 2;\n   optional string flight = 3;\n}\n\n";
    }

    private String getBrokenProtoBufferFile() {
        return "message travels {\n   optional stringa traveller = 1;\n   optional string hotel = 2;\n   optional string flight = 3;\n}\n\n";
    }

    private String getProtoBufferFileV1() {
        return "import \"kogito-index.proto\";\noption kogito_model=\"Game\";\noption kogito_id=\"game\";\nmessage Game {\n   optional string player = 1;\n   optional string id = 2;\n   optional string name = 3;\n   repeated org.kie.kogito.index.model.ProcessInstanceMeta processInstances = 4;\n}\n\n";
    }

    private String getProtoBufferFileV2() {
        return "import \"kogito-index.proto\";\noption kogito_model=\"Game\";\noption kogito_id=\"game\";\nmessage Game {\n   optional string id = 1;\n   optional string name = 2;\n   optional string company = 3;\n   repeated org.kie.kogito.index.model.ProcessInstanceMeta processInstances = 4;\n}\n\n";
    }
}

