/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.kogito.index.domain.AttributeDescriptor;
import org.kie.kogito.index.domain.DomainDescriptor;
import org.kie.kogito.index.event.DomainModelRegisteredEvent;
import org.kie.kogito.index.graphql.DomainModelDataFetcher;
import org.kie.kogito.index.graphql.GraphQLSchemaManager;
import org.kie.kogito.index.model.ProcessInstanceMeta;
import org.kie.kogito.index.query.QueryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class GraphQLProtoSchemaMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphQLProtoSchemaMapper.class);
    @Inject
    QueryService queryService;
    @Inject
    GraphQLSchemaManager schemaManager;

    private static String getTypeName(String type) {
        return type.contains(".") ? type.substring(type.lastIndexOf(".") + 1) : type;
    }

    public void onDomainModelRegisteredEvent(@Observes DomainModelRegisteredEvent event) {
        LOGGER.debug("Received new domain event: {}", (Object)event);
        GraphQLSchema schema = this.schemaManager.getGraphQLSchema();
        this.schemaManager.transform(builder -> {
            builder.clearAdditionalTypes();
            Map<String, DomainDescriptor> map = event.getAdditionalTypes().stream().collect(Collectors.toMap(desc -> GraphQLProtoSchemaMapper.getTypeName(desc.getTypeName()), desc -> desc));
            HashMap<String, GraphQLType> additionalTypes = new HashMap<String, GraphQLType>();
            GraphQLObjectType rootType = new GraphQLObjectTypeMapper(schema, additionalTypes, map).apply(event.getDomainDescriptor());
            additionalTypes.put(rootType.getName(), (GraphQLType)rootType);
            Set newTypes = additionalTypes.entrySet().stream().map(entry -> (GraphQLType)entry.getValue()).collect(Collectors.toSet());
            newTypes.addAll(schema.getAdditionalTypes().stream().filter(type -> !additionalTypes.containsKey(type.getName())).collect(Collectors.toSet()));
            LOGGER.debug("New GraphQL types: {}", newTypes);
            builder.additionalTypes(newTypes);
            GraphQLObjectType query = schema.getQueryType();
            query = query.transform(qBuilder -> {
                if (qBuilder.hasField(rootType.getName())) {
                    qBuilder.clearFields();
                    qBuilder.fields(schema.getQueryType().getFieldDefinitions().stream().filter(field -> !rootType.getName().equals(field.getName())).collect(Collectors.toList()));
                }
                GraphQLArgument argument = GraphQLArgument.newArgument().name("query").type((GraphQLInputType)Scalars.GraphQLString).build();
                qBuilder.field(GraphQLFieldDefinition.newFieldDefinition().name(rootType.getName()).type((GraphQLOutputType)GraphQLList.list((GraphQLType)rootType)).argument(argument));
            });
            builder.query(query);
            GraphQLCodeRegistry registry = schema.getCodeRegistry().transform(codeBuilder -> codeBuilder.dataFetcher(FieldCoordinates.coordinates((String)"Query", (String)rootType.getName()), (DataFetcher)new DomainModelDataFetcher(this.queryService, event.getProcessId())));
            builder.codeRegistry(registry);
        });
    }

    private GraphQLOutputType getGraphQLType(AttributeDescriptor attribute, GraphQLSchema schema, Map<String, GraphQLType> additionalTypes, Map<String, DomainDescriptor> allTypes) {
        String typeName = GraphQLProtoSchemaMapper.getTypeName(attribute.getTypeName());
        GraphQLType type = schema.getType(typeName);
        if (type == null && (type = additionalTypes.get(typeName)) == null) {
            type = new GraphQLObjectTypeMapper(schema, additionalTypes, allTypes).apply(allTypes.get(typeName));
            additionalTypes.put(typeName, type);
        }
        return (GraphQLOutputType)type;
    }

    private class GraphQLObjectTypeMapper
    implements Function<DomainDescriptor, GraphQLObjectType> {
        GraphQLSchema schema;
        Map<String, GraphQLType> additionalTypes;
        Map<String, DomainDescriptor> allTypes;

        public GraphQLObjectTypeMapper(GraphQLSchema schema, Map<String, GraphQLType> additionalTypes, Map<String, DomainDescriptor> allTypes) {
            this.schema = schema;
            this.additionalTypes = additionalTypes;
            this.allTypes = allTypes;
        }

        @Override
        public GraphQLObjectType apply(DomainDescriptor domain) {
            LOGGER.debug("GraphQL mapping domain: {}", (Object)domain);
            String typeName = GraphQLProtoSchemaMapper.getTypeName(domain.getTypeName());
            GraphQLObjectType existingType = (GraphQLObjectType)this.schema.getType(typeName);
            if (existingType == null) {
                GraphQLObjectType.Builder builder2 = GraphQLObjectType.newObject().name(typeName);
                this.build(domain).accept(builder2);
                return builder2.build();
            }
            return existingType.transform(builder -> {
                builder.clearFields();
                this.build(domain).accept((GraphQLObjectType.Builder)builder);
            });
        }

        private Consumer<GraphQLObjectType.Builder> build(DomainDescriptor domain) {
            return builder -> domain.getAttributes().forEach(field -> {
                LOGGER.debug("GraphQL mapping field: {}", field);
                if (ProcessInstanceMeta.class.getName().equals(field.getTypeName())) {
                    builder.field(GraphQLFieldDefinition.newFieldDefinition().name("processInstances").type((GraphQLOutputType)GraphQLList.list((GraphQLType)this.schema.getObjectType("ProcessInstanceMeta")))).build();
                } else {
                    GraphQLScalarType type;
                    switch (field.getTypeName()) {
                        case "java.lang.Integer": {
                            type = Scalars.GraphQLInt;
                            break;
                        }
                        case "java.lang.Long": {
                            type = Scalars.GraphQLLong;
                            break;
                        }
                        case "java.lang.String": 
                        case "java.util.Date": {
                            type = Scalars.GraphQLString;
                            break;
                        }
                        case "java.lang.Boolean": {
                            type = Scalars.GraphQLBoolean;
                            break;
                        }
                        default: {
                            type = GraphQLProtoSchemaMapper.this.getGraphQLType(field, this.schema, this.additionalTypes, this.allTypes);
                        }
                    }
                    builder.field(GraphQLFieldDefinition.newFieldDefinition().name(field.getName()).type((GraphQLOutputType)type));
                }
            });
        }
    }
}

