/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.config.EncoderConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.GraphQLUtils;
import org.kie.kogito.index.InfinispanServerTestResource;
import org.kie.kogito.index.TestUtils;
import org.kie.kogito.index.event.KogitoProcessCloudEvent;
import org.kie.kogito.index.event.KogitoUserTaskCloudEvent;
import org.kie.kogito.index.infinispan.protostream.ProtobufService;
import org.kie.kogito.index.messaging.ReactiveMessagingEventConsumer;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceState;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.query.ProcessInstanceFilter;
import org.kie.kogito.index.query.UserTaskInstanceFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@QuarkusTest
@QuarkusTestResource(value=InfinispanServerTestResource.class)
public class IndexingServiceTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexingServiceTest.class);
    @Inject
    ReactiveMessagingEventConsumer consumer;
    @Inject
    ProtobufService protobufService;

    @BeforeAll
    public static void setup() {
        RestAssured.config = RestAssured.config().encoderConfig(EncoderConfig.encoderConfig().appendDefaultContentCharsetToContentTypeIfUndefined(false));
    }

    private static String formatZonedDateTime(ZonedDateTime time) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(time);
    }

    @Test
    public void testAddBrokenProtoFile() {
        try {
            this.protobufService.registerProtoBufferType(this.getBrokenProtoBufferFile());
            Assertions.fail((String)"Registering broken proto file should fail");
        }
        catch (Exception ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo((Object)"Failed to resolve type of field \"travels.traveller\". Type not found : stringa");
        }
    }

    @Test
    public void testAddProtoFileMissingModel() {
        try {
            this.protobufService.registerProtoBufferType(this.getProtoBufferFileWithoutModel());
            Assertions.fail((String)"Registering broken proto file should fail");
        }
        catch (Exception ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo((Object)"Missing marker for main message type in proto file, please add option kogito_model=\"messagename\"");
        }
    }

    @Test
    public void testAddProtoFileMissingId() {
        try {
            this.protobufService.registerProtoBufferType(this.getProtoBufferFileWithoutId());
            Assertions.fail((String)"Registering broken proto file should fail");
        }
        catch (Exception ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo((Object)"Missing marker for process id in proto file, please add option kogito_id=\"processid\"");
        }
    }

    @Test
    public void testAddProtoFileMissingModelType() {
        try {
            this.protobufService.registerProtoBufferType(this.getProtoBufferFileWithoutModelType());
            Assertions.fail((String)"Registering broken proto file should fail");
        }
        catch (Exception ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo((Object)"Could not find message with name: traveller in proto file, e, please review option kogito_model");
        }
    }

    @Test
    public void testAddProtoFileTwice() throws Exception {
        this.protobufService.registerProtoBufferType(this.getProtoBufferFileV1());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{Game{ player, id, name, processInstances { id } } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Game", CoreMatchers.isA(Collection.class), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ProcessInstances{ id, processId, rootProcessId, rootProcessInstanceId, parentProcessInstanceId } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.ProcessInstances", CoreMatchers.isA(Collection.class), new Object[0]);
        this.protobufService.registerProtoBufferType(this.getProtoBufferFileV2());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{Game{ id, name, company, processInstances { id } } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Game", CoreMatchers.isA(Collection.class), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ProcessInstances{ id, processId, rootProcessId, rootProcessInstanceId, parentProcessInstanceId } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.ProcessInstances", CoreMatchers.isA(Collection.class), new Object[0]);
    }

    @Test
    public void testAddProtoFile() throws Exception {
        String processId = "travels";
        String subProcessId = processId + "_sub";
        String processInstanceId = UUID.randomUUID().toString();
        String subProcessInstanceId = UUID.randomUUID().toString();
        String taskId = UUID.randomUUID().toString();
        this.protobufService.registerProtoBufferType(TestUtils.getTravelsProtoBufferFile());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{Travels{ id } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels", CoreMatchers.isA(Collection.class), new Object[0]);
        KogitoProcessCloudEvent startEvent = TestUtils.getProcessCloudEvent(processId, processInstanceId, ProcessInstanceState.ACTIVE, null, null, null);
        this.indexProcessCloudEvent(startEvent);
        this.validateProcessInstance(GraphQLUtils.toGraphQLString(ProcessInstanceFilter.builder().id(Collections.singletonList(processInstanceId)).state(Collections.singletonList(ProcessInstanceState.ACTIVE.ordinal())).build()), startEvent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{Travels(query: \\\"from org.acme.travels.travels.Travels t where t.traveller.firstName:'ma*' and t.processInstances.id:'" + processInstanceId + "'\\\"){ id, flight { flightNumber }, hotel { name }, traveller { firstName }, processInstances { id, processId, rootProcessId, rootProcessInstanceId, parentProcessInstanceId, start, end } } }\"}").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].processInstances.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Travels[0].processInstances[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].processInstances[0].processId", CoreMatchers.is((Object)processId), new Object[0])).body("data.Travels[0].processInstances[0].rootProcessId", Matchers.isEmptyOrNullString(), new Object[0])).body("data.Travels[0].processInstances[0].rootProcessInstanceId", Matchers.isEmptyOrNullString(), new Object[0])).body("data.Travels[0].processInstances[0].parentProcessInstanceId", Matchers.isEmptyOrNullString(), new Object[0])).body("data.Travels[0].processInstances[0].start", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)startEvent.getData()).getStart().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].processInstances[0].end", Matchers.isEmptyOrNullString(), new Object[0])).body("data.Travels[0].traveller.firstName", CoreMatchers.is((Object)"Maciej"), new Object[0])).body("data.Travels[0].hotel.name", CoreMatchers.is((Object)"Meriton"), new Object[0])).body("data.Travels[0].flight.flightNumber", CoreMatchers.is((Object)"MX555"), new Object[0]);
        KogitoProcessCloudEvent subProcessStartEvent = TestUtils.getProcessCloudEvent(subProcessId, subProcessInstanceId, ProcessInstanceState.ACTIVE, processInstanceId, processId, processInstanceId);
        this.indexProcessCloudEvent(subProcessStartEvent);
        this.validateProcessInstance(GraphQLUtils.toGraphQLString(ProcessInstanceFilter.builder().id(Collections.singletonList(subProcessInstanceId)).state(Collections.singletonList(ProcessInstanceState.ACTIVE.ordinal())).build()), subProcessStartEvent);
        KogitoProcessCloudEvent endEvent = TestUtils.getProcessCloudEvent(processId, processInstanceId, ProcessInstanceState.COMPLETED, null, null, null);
        this.indexProcessCloudEvent(endEvent);
        this.validateProcessInstance(GraphQLUtils.toGraphQLString(ProcessInstanceFilter.builder().id(Collections.singletonList(processInstanceId)).state(Collections.singletonList(ProcessInstanceState.COMPLETED.ordinal())).build()), endEvent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{Travels(query: \\\"from org.acme.travels.travels.Travels t where t.traveller.firstName:'ma*' and t.processInstances.id:'" + subProcessInstanceId + "'\\\"){ id, flight { flightNumber, arrival, departure }, hotel { name }, traveller { firstName }, processInstances { id, processId, rootProcessId, rootProcessInstanceId, parentProcessInstanceId, start, end } } }\"}").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].processInstances.size()", CoreMatchers.is((Object)2), new Object[0])).body("data.Travels[0].processInstances[1].id", CoreMatchers.is((Object)subProcessInstanceId), new Object[0])).body("data.Travels[0].processInstances[1].processId", CoreMatchers.is((Object)subProcessId), new Object[0])).body("data.Travels[0].processInstances[1].rootProcessId", CoreMatchers.is((Object)processId), new Object[0])).body("data.Travels[0].processInstances[1].rootProcessInstanceId", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].processInstances[1].parentProcessInstanceId", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].processInstances[1].start", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)subProcessStartEvent.getData()).getStart().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.Travels[0].processInstances[1].end", Matchers.isEmptyOrNullString(), new Object[0])).body("data.Travels[0].traveller.firstName", CoreMatchers.is((Object)"Maciej"), new Object[0])).body("data.Travels[0].hotel.name", CoreMatchers.is((Object)"Meriton"), new Object[0])).body("data.Travels[0].flight.flightNumber", CoreMatchers.is((Object)"MX555"), new Object[0])).body("data.Travels[0].flight.arrival", CoreMatchers.is((Object)"2019-08-20T22:12:57.340Z"), new Object[0])).body("data.Travels[0].flight.departure", CoreMatchers.is((Object)"2019-08-20T07:12:57.340Z"), new Object[0]);
        KogitoUserTaskCloudEvent userTaskEvent = TestUtils.getUserTaskCloudEvent(taskId, subProcessId, subProcessInstanceId, processInstanceId, processId);
        this.indexUserTaskCloudEvent(userTaskEvent);
        this.validateUserTaskInstance(GraphQLUtils.toGraphQLString(UserTaskInstanceFilter.builder().id(Collections.singletonList(taskId)).build()), userTaskEvent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{Travels(query: \\\"from org.acme.travels.travels.Travels t where t.userTasks.id:'" + taskId + "'\\\"){ id, flight { flightNumber, arrival, departure }, hotel { name }, traveller { firstName }, userTasks { id, description, name, priority, processInstanceId, actualOwner } } }\"}").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].userTasks.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Travels[0].userTasks[0].id", CoreMatchers.is((Object)taskId), new Object[0])).body("data.Travels[0].userTasks[0].processInstanceId", CoreMatchers.is((Object)subProcessInstanceId), new Object[0])).body("data.Travels[0].userTasks[0].description", CoreMatchers.is((Object)"TaskDescription"), new Object[0])).body("data.Travels[0].userTasks[0].name", CoreMatchers.is((Object)"TaskName"), new Object[0])).body("data.Travels[0].userTasks[0].priority", CoreMatchers.is((Object)"High"), new Object[0])).body("data.Travels[0].userTasks[0].actualOwner", CoreMatchers.is((Object)"kogito"), new Object[0]);
    }

    private void validateProcessInstance(String query, KogitoProcessCloudEvent event) {
        LOGGER.debug("GraphQL query: {}", (Object)query);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(query).when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.ProcessInstances[0].id", CoreMatchers.is((Object)event.getProcessInstanceId()), new Object[0])).body("data.ProcessInstances[0].processId", CoreMatchers.is((Object)event.getProcessId()), new Object[0])).body("data.ProcessInstances[0].rootProcessId", CoreMatchers.is((Object)event.getRootProcessId()), new Object[0])).body("data.ProcessInstances[0].rootProcessInstanceId", CoreMatchers.is((Object)event.getRootProcessInstanceId()), new Object[0])).body("data.ProcessInstances[0].parentProcessInstanceId", CoreMatchers.is((Object)event.getParentProcessInstanceId()), new Object[0])).body("data.ProcessInstances[0].start", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)event.getData()).getStart().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.ProcessInstances[0].end", ((ProcessInstance)event.getData()).getEnd() == null ? Matchers.isEmptyOrNullString() : CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((ProcessInstance)event.getData()).getEnd().withZoneSameInstant(ZoneOffset.UTC))), new Object[0]);
    }

    private void indexProcessCloudEvent(KogitoProcessCloudEvent event) {
        this.consumer.onProcessInstanceEvent(event);
        this.consumer.onProcessInstanceDomainEvent(event);
    }

    private void indexUserTaskCloudEvent(KogitoUserTaskCloudEvent event) {
        this.consumer.onUserTaskInstanceEvent(event);
        this.consumer.onUserTaskInstanceDomainEvent(event);
    }

    @Test
    public void testIndexingDomainUsingUserTaskEventFirst() throws Exception {
        String taskId = UUID.randomUUID().toString();
        String processId = "travels";
        String processInstanceId = UUID.randomUUID().toString();
        this.protobufService.registerProtoBufferType(TestUtils.getTravelsProtoBufferFile());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ Travels{ id } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels", CoreMatchers.isA(Collection.class), new Object[0]);
        KogitoUserTaskCloudEvent userTaskEvent = TestUtils.getUserTaskCloudEvent(taskId, processId, processInstanceId, null, null);
        this.consumer.onUserTaskInstanceDomainEvent(userTaskEvent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{Travels(query: \\\"from org.acme.travels.travels.Travels t where t.userTasks.id:'" + taskId + "'\\\"){ id, flight { flightNumber, arrival, departure }, hotel { name }, traveller { firstName }, processInstances { id, processId, rootProcessId, rootProcessInstanceId, parentProcessInstanceId, start, end }, userTasks { id, description, name, priority, processInstanceId, actualOwner } } }\"}").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].flight", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].hotel", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].traveller", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].userTasks.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Travels[0].userTasks[0].id", CoreMatchers.is((Object)taskId), new Object[0])).body("data.Travels[0].userTasks[0].processInstanceId", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].userTasks[0].description", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getDescription()), new Object[0])).body("data.Travels[0].userTasks[0].name", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getName()), new Object[0])).body("data.Travels[0].userTasks[0].priority", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getPriority()), new Object[0])).body("data.Travels[0].userTasks[0].actualOwner", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getActualOwner()), new Object[0])).body("data.Travels[0].processInstances", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0]);
        KogitoProcessCloudEvent processEvent = TestUtils.getProcessCloudEvent(processId, processInstanceId, ProcessInstanceState.ACTIVE, null, null, null);
        this.consumer.onProcessInstanceDomainEvent(processEvent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{Travels(query: \\\"from org.acme.travels.travels.Travels t where t.processInstances.id:'" + processInstanceId + "'\\\"){ id, flight { flightNumber }, hotel { name }, traveller { firstName }, processInstances { id, processId, rootProcessId, rootProcessInstanceId, parentProcessInstanceId }, userTasks { id, description, name, priority, processInstanceId, actualOwner } } }\"}").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].flight.flightNumber", CoreMatchers.is((Object)"MX555"), new Object[0])).body("data.Travels[0].hotel.name", CoreMatchers.is((Object)"Meriton"), new Object[0])).body("data.Travels[0].traveller.firstName", CoreMatchers.is((Object)"Maciej"), new Object[0])).body("data.Travels[0].userTasks.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Travels[0].userTasks[0].id", CoreMatchers.is((Object)taskId), new Object[0])).body("data.Travels[0].userTasks[0].processInstanceId", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].userTasks[0].description", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getDescription()), new Object[0])).body("data.Travels[0].userTasks[0].name", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getName()), new Object[0])).body("data.Travels[0].userTasks[0].priority", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getPriority()), new Object[0])).body("data.Travels[0].userTasks[0].actualOwner", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getActualOwner()), new Object[0])).body("data.Travels[0].processInstances.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Travels[0].processInstances[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].processInstances[0].processId", CoreMatchers.is((Object)processId), new Object[0])).body("data.Travels[0].processInstances[0].rootProcessId", Matchers.isEmptyOrNullString(), new Object[0])).body("data.Travels[0].processInstances[0].rootProcessInstanceId", Matchers.isEmptyOrNullString(), new Object[0])).body("data.Travels[0].processInstances[0].parentProcessInstanceId", Matchers.isEmptyOrNullString(), new Object[0]);
    }

    @Test
    public void testIndexingDomainUsingProcessEventFirst() throws Exception {
        String taskId = UUID.randomUUID().toString();
        String processId = "travels";
        String processInstanceId = UUID.randomUUID().toString();
        this.protobufService.registerProtoBufferType(TestUtils.getTravelsProtoBufferFile());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ Travels{ id } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels", CoreMatchers.isA(Collection.class), new Object[0]);
        KogitoProcessCloudEvent processEvent = TestUtils.getProcessCloudEvent(processId, processInstanceId, ProcessInstanceState.ACTIVE, null, null, null);
        this.consumer.onProcessInstanceDomainEvent(processEvent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{Travels(query: \\\"from org.acme.travels.travels.Travels t where t.processInstances.id:'" + processInstanceId + "'\\\"){ id, flight { flightNumber }, hotel { name }, traveller { firstName }, processInstances { id, processId, rootProcessId, rootProcessInstanceId, parentProcessInstanceId }, userTasks { id, description, name, priority, processInstanceId, actualOwner } } }\"}").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].flight.flightNumber", CoreMatchers.is((Object)"MX555"), new Object[0])).body("data.Travels[0].hotel.name", CoreMatchers.is((Object)"Meriton"), new Object[0])).body("data.Travels[0].traveller.firstName", CoreMatchers.is((Object)"Maciej"), new Object[0])).body("data.Travels[0].userTasks", CoreMatchers.is((Matcher)CoreMatchers.nullValue()), new Object[0])).body("data.Travels[0].processInstances.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Travels[0].processInstances[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].processInstances[0].processId", CoreMatchers.is((Object)processId), new Object[0])).body("data.Travels[0].processInstances[0].rootProcessId", Matchers.isEmptyOrNullString(), new Object[0])).body("data.Travels[0].processInstances[0].rootProcessInstanceId", Matchers.isEmptyOrNullString(), new Object[0])).body("data.Travels[0].processInstances[0].parentProcessInstanceId", Matchers.isEmptyOrNullString(), new Object[0]);
        KogitoUserTaskCloudEvent userTaskEvent = TestUtils.getUserTaskCloudEvent(taskId, processId, processInstanceId, null, null);
        this.consumer.onUserTaskInstanceDomainEvent(userTaskEvent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{Travels(query: \\\"from org.acme.travels.travels.Travels t where t.userTasks.id:'" + taskId + "'\\\"){ id, flight { flightNumber, arrival, departure }, hotel { name }, traveller { firstName }, processInstances { id, processId, rootProcessId, rootProcessInstanceId, parentProcessInstanceId, start, end }, userTasks { id, description, name, priority, processInstanceId, actualOwner } } }\"}").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].flight.flightNumber", CoreMatchers.is((Object)"MX555"), new Object[0])).body("data.Travels[0].hotel.name", CoreMatchers.is((Object)"Meriton"), new Object[0])).body("data.Travels[0].traveller.firstName", CoreMatchers.is((Object)"Maciej"), new Object[0])).body("data.Travels[0].userTasks.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Travels[0].userTasks[0].id", CoreMatchers.is((Object)taskId), new Object[0])).body("data.Travels[0].userTasks[0].processInstanceId", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].userTasks[0].description", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getDescription()), new Object[0])).body("data.Travels[0].userTasks[0].name", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getName()), new Object[0])).body("data.Travels[0].userTasks[0].priority", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getPriority()), new Object[0])).body("data.Travels[0].userTasks[0].actualOwner", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getActualOwner()), new Object[0])).body("data.Travels[0].processInstances.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Travels[0].processInstances[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].processInstances[0].processId", CoreMatchers.is((Object)processId), new Object[0])).body("data.Travels[0].processInstances[0].rootProcessId", Matchers.isEmptyOrNullString(), new Object[0])).body("data.Travels[0].processInstances[0].rootProcessInstanceId", Matchers.isEmptyOrNullString(), new Object[0])).body("data.Travels[0].processInstances[0].parentProcessInstanceId", Matchers.isEmptyOrNullString(), new Object[0]);
    }

    @Test
    public void testIndexingDomainParallelEvents() throws Exception {
        String taskId = UUID.randomUUID().toString();
        String processId = "travels";
        String processInstanceId = UUID.randomUUID().toString();
        this.protobufService.registerProtoBufferType(TestUtils.getTravelsProtoBufferFile());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ Travels{ id } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels", CoreMatchers.isA(Collection.class), new Object[0]);
        KogitoProcessCloudEvent processEvent = TestUtils.getProcessCloudEvent(processId, processInstanceId, ProcessInstanceState.ACTIVE, null, null, null);
        KogitoUserTaskCloudEvent userTaskEvent = TestUtils.getUserTaskCloudEvent(taskId, processId, processInstanceId, null, null);
        CompletableFuture.allOf(CompletableFuture.runAsync(() -> this.consumer.onProcessInstanceDomainEvent(processEvent)), CompletableFuture.runAsync(() -> this.consumer.onUserTaskInstanceDomainEvent(userTaskEvent))).get();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{Travels(query: \\\"from org.acme.travels.travels.Travels t where t.processInstances.id:'" + processInstanceId + "'\\\"){ id, flight { flightNumber, arrival, departure }, hotel { name }, traveller { firstName }, processInstances { id, processId, rootProcessId, rootProcessInstanceId, parentProcessInstanceId, start, end }, userTasks { id, description, name, priority, processInstanceId, actualOwner } } }\"}").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Travels[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].flight.flightNumber", CoreMatchers.is((Object)"MX555"), new Object[0])).body("data.Travels[0].hotel.name", CoreMatchers.is((Object)"Meriton"), new Object[0])).body("data.Travels[0].traveller.firstName", CoreMatchers.is((Object)"Maciej"), new Object[0])).body("data.Travels[0].userTasks.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Travels[0].userTasks[0].id", CoreMatchers.is((Object)taskId), new Object[0])).body("data.Travels[0].userTasks[0].processInstanceId", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].userTasks[0].description", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getDescription()), new Object[0])).body("data.Travels[0].userTasks[0].name", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getName()), new Object[0])).body("data.Travels[0].userTasks[0].priority", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getPriority()), new Object[0])).body("data.Travels[0].userTasks[0].actualOwner", CoreMatchers.is((Object)((UserTaskInstance)userTaskEvent.getData()).getActualOwner()), new Object[0])).body("data.Travels[0].processInstances.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Travels[0].processInstances[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Travels[0].processInstances[0].processId", CoreMatchers.is((Object)processId), new Object[0])).body("data.Travels[0].processInstances[0].rootProcessId", Matchers.isEmptyOrNullString(), new Object[0])).body("data.Travels[0].processInstances[0].rootProcessInstanceId", Matchers.isEmptyOrNullString(), new Object[0])).body("data.Travels[0].processInstances[0].parentProcessInstanceId", Matchers.isEmptyOrNullString(), new Object[0]);
    }

    @Test
    public void testUserTaskInstanceIndex() throws Exception {
        String taskId = UUID.randomUUID().toString();
        String processId = "deals";
        String processInstanceId = UUID.randomUUID().toString();
        this.protobufService.registerProtoBufferType(TestUtils.getDealsProtoBufferFile());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ Deals{ id } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Deals", CoreMatchers.isA(Collection.class), new Object[0]);
        KogitoUserTaskCloudEvent event = TestUtils.getUserTaskCloudEvent(taskId, processId, processInstanceId, null, null);
        this.indexUserTaskCloudEvent(event);
        this.validateUserTaskInstance(GraphQLUtils.toGraphQLString(UserTaskInstanceFilter.builder().id(Collections.singletonList(taskId)).build()), event);
        this.validateUserTaskInstance(GraphQLUtils.toGraphQLString(UserTaskInstanceFilter.builder().id(Collections.singletonList(taskId)).actualOwner(Collections.singletonList("kogito")).build()), event);
        this.validateUserTaskInstance(GraphQLUtils.toGraphQLString(UserTaskInstanceFilter.builder().id(Collections.singletonList(taskId)).potentialGroups(new ArrayList(((UserTaskInstance)event.getData()).getPotentialGroups())).build()), event);
        this.validateUserTaskInstance(GraphQLUtils.toGraphQLString(UserTaskInstanceFilter.builder().id(Collections.singletonList(taskId)).potentialUsers(new ArrayList(((UserTaskInstance)event.getData()).getPotentialUsers())).build()), event);
        this.validateUserTaskInstance(GraphQLUtils.toGraphQLString(UserTaskInstanceFilter.builder().id(Collections.singletonList(taskId)).state(Collections.singletonList(((UserTaskInstance)event.getData()).getState())).build()), event);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{Deals(query: \\\"from org.acme.deals.Deals d where d.userTasks.id:'" + taskId + "'\\\"){ id, name, review, userTasks { id, description, name, priority, processInstanceId, actualOwner } } }\"}").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.Deals[0].id", CoreMatchers.is((Object)processInstanceId), new Object[0])).body("data.Deals[0].userTasks.size()", CoreMatchers.is((Object)1), new Object[0])).body("data.Deals[0].userTasks[0].id", CoreMatchers.is((Object)taskId), new Object[0])).body("data.Deals[0].userTasks[0].description", CoreMatchers.is((Object)"TaskDescription"), new Object[0])).body("data.Deals[0].userTasks[0].name", CoreMatchers.is((Object)"TaskName"), new Object[0])).body("data.Deals[0].userTasks[0].priority", CoreMatchers.is((Object)"High"), new Object[0])).body("data.Deals[0].userTasks[0].actualOwner", CoreMatchers.is((Object)"kogito"), new Object[0]);
    }

    private void validateUserTaskInstance(String query, KogitoUserTaskCloudEvent event) {
        LOGGER.debug("GraphQL query: {}", (Object)query);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(query).when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.UserTaskInstances[0].id", CoreMatchers.is((Object)event.getUserTaskInstanceId()), new Object[0])).body("data.UserTaskInstances[0].processId", CoreMatchers.is((Object)event.getProcessId()), new Object[0])).body("data.UserTaskInstances[0].rootProcessId", CoreMatchers.is((Object)event.getRootProcessId()), new Object[0])).body("data.UserTaskInstances[0].rootProcessInstanceId", CoreMatchers.is((Object)event.getRootProcessInstanceId()), new Object[0])).body("data.UserTaskInstances[0].description", CoreMatchers.is((Object)((UserTaskInstance)event.getData()).getDescription()), new Object[0])).body("data.UserTaskInstances[0].name", CoreMatchers.is((Object)((UserTaskInstance)event.getData()).getName()), new Object[0])).body("data.UserTaskInstances[0].priority", CoreMatchers.is((Object)((UserTaskInstance)event.getData()).getPriority()), new Object[0])).body("data.UserTaskInstances[0].actualOwner", CoreMatchers.is((Object)((UserTaskInstance)event.getData()).getActualOwner()), new Object[0])).body("data.UserTaskInstances[0].excludedUsers", Matchers.hasItems((Object[])((UserTaskInstance)event.getData()).getExcludedUsers().toArray()), new Object[0])).body("data.UserTaskInstances[0].potentialUsers", Matchers.hasItems((Object[])((UserTaskInstance)event.getData()).getPotentialUsers().toArray()), new Object[0])).body("data.UserTaskInstances[0].potentialGroups", Matchers.hasItems((Object[])((UserTaskInstance)event.getData()).getPotentialGroups().toArray()), new Object[0])).body("data.UserTaskInstances[0].started", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((UserTaskInstance)event.getData()).getStarted().withZoneSameInstant(ZoneOffset.UTC))), new Object[0])).body("data.UserTaskInstances[0].completed", CoreMatchers.is((Object)IndexingServiceTest.formatZonedDateTime(((UserTaskInstance)event.getData()).getCompleted().withZoneSameInstant(ZoneOffset.UTC))), new Object[0]);
    }

    private String getProtoBufferFileWithoutModelType() {
        return "   option kogito_id=\"travels\";\n   option kogito_model=\"traveller\";\nmessage travels {\n   optional string traveller = 1;\n   optional string hotel = 2;\n   optional string flight = 3;\n}\n\n";
    }

    private String getProtoBufferFileWithoutId() {
        return "   option kogito_model=\"travels\";\nmessage travels {\n   optional string traveller = 1;\n   optional string hotel = 2;\n   optional string flight = 3;\n}\n\n";
    }

    private String getProtoBufferFileWithoutModel() {
        return "   option kogito_id=\"travels\";\nmessage travels {\n   optional string traveller = 1;\n   optional string hotel = 2;\n   optional string flight = 3;\n}\n\n";
    }

    private String getBrokenProtoBufferFile() {
        return "message travels {\n   optional stringa traveller = 1;\n   optional string hotel = 2;\n   optional string flight = 3;\n}\n\n";
    }

    private String getProtoBufferFileV1() {
        return "import \"kogito-index.proto\";\noption kogito_model=\"Game\";\noption kogito_id=\"game\";\nmessage Game {\n   optional string player = 1;\n   optional string id = 2;\n   optional string name = 3;\n   repeated org.kie.kogito.index.model.ProcessInstanceMeta processInstances = 4;\n   repeated org.kie.kogito.index.model.UserTaskInstanceMeta userTasks = 5;\n}\n\n";
    }

    private String getProtoBufferFileV2() {
        return "import \"kogito-index.proto\";\noption kogito_model=\"Game\";\noption kogito_id=\"game\";\nmessage Game {\n   optional string id = 1;\n   optional string name = 2;\n   optional string company = 3;\n   repeated org.kie.kogito.index.model.ProcessInstanceMeta processInstances = 4;\n   repeated org.kie.kogito.index.model.UserTaskInstanceMeta userTasks = 5;\n}\n\n";
    }
}

