/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.kie.kogito.index.event.KogitoProcessCloudEvent;
import org.kie.kogito.index.event.KogitoUserTaskCloudEvent;
import org.kie.kogito.index.model.NodeInstance;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceState;
import org.kie.kogito.index.model.UserTaskInstance;

public final class TestUtils {
    private TestUtils() {
    }

    public static String getDealsProtoBufferFile() throws Exception {
        return TestUtils.getProtoFile("deals.proto");
    }

    public static String getTravelsProtoBufferFile() throws Exception {
        return TestUtils.getProtoFile("travels.proto");
    }

    private static String getProtoFile(String file) throws URISyntaxException, IOException {
        Path path = Paths.get(Thread.currentThread().getContextClassLoader().getResource(file).toURI());
        return new String(Files.readAllBytes(path));
    }

    public static KogitoProcessCloudEvent getProcessCloudEvent(String processId, String processInstanceId, ProcessInstanceState status, String rootProcessInstanceId, String rootProcessId, String parentProcessInstanceId) {
        return KogitoProcessCloudEvent.builder().id(UUID.randomUUID().toString()).rootProcessInstanceId(rootProcessInstanceId).rootProcessId(rootProcessId).parentProcessInstanceId(parentProcessInstanceId).processId(processId).state(Integer.valueOf(status.ordinal())).contentType("application/json").processInstanceId(processInstanceId).type("ProcessInstanceEvent").source(URI.create("http://localhost:8080/")).time(ZonedDateTime.now()).data(TestUtils.getProcessInstance(processId, processInstanceId, status.ordinal(), rootProcessInstanceId, rootProcessId)).build();
    }

    private static ProcessInstance getProcessInstance(String processId, String processInstanceId, Integer status, String rootProcessInstanceId, String rootProcessId) {
        ProcessInstance pi = new ProcessInstance();
        pi.setId(processInstanceId);
        pi.setProcessId(processId);
        pi.setRootProcessInstanceId(rootProcessInstanceId);
        pi.setParentProcessInstanceId(rootProcessInstanceId);
        pi.setRootProcessId(rootProcessId);
        pi.setRoles(Collections.singleton("admin"));
        pi.setVariables(TestUtils.getProcessInstanceVariables());
        pi.setNodes(TestUtils.getNodeInstances());
        pi.setEndpoint("http://localhost:8080/");
        pi.setState(status);
        pi.setStart(ZonedDateTime.now());
        pi.setEnd(status.intValue() == ProcessInstanceState.COMPLETED.ordinal() ? ZonedDateTime.now().plus(1L, ChronoUnit.HOURS) : null);
        return pi;
    }

    private static List<NodeInstance> getNodeInstances() {
        NodeInstance ni = new NodeInstance();
        ni.setId(UUID.randomUUID().toString());
        ni.setEnter(ZonedDateTime.now());
        ni.setName("Start");
        ni.setType("StartNode");
        ni.setNodeId("1");
        ni.setDefinitionId("StartEvent_1");
        return Lists.newArrayList((Object[])new NodeInstance[]{ni});
    }

    private static String getProcessInstanceVariables() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        HashMap<String, String> traveller = new HashMap<String, String>();
        traveller.put("firstName", "Maciej");
        builder.add("traveller", (JsonValue)Json.createObjectBuilder(traveller).build());
        HashMap<String, String> hotel = new HashMap<String, String>();
        hotel.put("name", "Meriton");
        builder.add("hotel", (JsonValue)Json.createObjectBuilder(hotel).build());
        HashMap<String, String> flight = new HashMap<String, String>();
        flight.put("flightNumber", "MX555");
        flight.put("arrival", "2019-08-20T22:12:57.340Z");
        flight.put("departure", "2019-08-20T07:12:57.340Z");
        builder.add("flight", (JsonValue)Json.createObjectBuilder(flight).build());
        return builder.build().toString();
    }

    public static KogitoUserTaskCloudEvent getUserTaskCloudEvent(String taskId, String processId, String processInstanceId, String rootProcessInstanceId, String rootProcessId) {
        return KogitoUserTaskCloudEvent.builder().id(UUID.randomUUID().toString()).userTaskInstanceId(taskId).rootProcessInstanceId(rootProcessInstanceId).rootProcessId(rootProcessId).processId(processId).contentType("application/json").processInstanceId(processInstanceId).type("UserTaskInstanceEvent").source(URI.create("http://localhost:8080/")).time(ZonedDateTime.now()).data(TestUtils.getUserTaskInstance(taskId, processId, processInstanceId, rootProcessInstanceId, rootProcessId)).build();
    }

    private static UserTaskInstance getUserTaskInstance(String taskId, String processId, String processInstanceId, String rootProcessInstanceId, String rootProcessId) {
        UserTaskInstance task = new UserTaskInstance();
        task.setId(taskId);
        task.setProcessInstanceId(processInstanceId);
        task.setProcessId(processId);
        task.setRootProcessId(rootProcessId);
        task.setRootProcessInstanceId(rootProcessInstanceId);
        task.setName("TaskName");
        task.setDescription("TaskDescription");
        task.setState("InProgress");
        task.setPriority("High");
        task.setStarted(ZonedDateTime.now());
        task.setCompleted(ZonedDateTime.now().plus(1L, ChronoUnit.HOURS));
        task.setActualOwner("kogito");
        task.setAdminUsers(Collections.singleton("kogito"));
        task.setAdminGroups(Collections.singleton("admin"));
        task.setExcludedUsers(Collections.singleton("excluded"));
        task.setPotentialUsers(Collections.singleton("potentialUser"));
        task.setPotentialGroups(Collections.singleton("potentialGroup"));
        return task;
    }
}

