/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql;

import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import io.quarkus.test.junit.QuarkusTest;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class DateTimeScalarTypeTest {
    @Inject
    GraphQLScalarType dateTimeScalar;

    @Test
    public void testParseValue() {
        Assertions.assertThat((String)this.dateTimeScalar.getName()).isEqualTo((Object)"DateTime");
        Assertions.assertThat((Object)this.dateTimeScalar.getCoercing().parseValue(null)).isNull();
    }

    @Test
    public void testParseLiteral() {
        Assertions.assertThat((String)this.dateTimeScalar.getName()).isEqualTo((Object)"DateTime");
        Assertions.assertThat((Object)this.dateTimeScalar.getCoercing().parseLiteral(null)).isNull();
    }

    @Test
    public void testSerializeNull() {
        Assertions.assertThat((String)this.dateTimeScalar.getName()).isEqualTo((Object)"DateTime");
        try {
            this.dateTimeScalar.getCoercing().serialize(null);
            Assertions.fail((String)"Method should throw CoercingSerializeException");
        }
        catch (CoercingSerializeException ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo((Object)"Expected something we can convert to 'java.time.OffsetDateTime' but was 'null'.");
        }
    }

    @Test
    public void testSerializeInvalidType() {
        Assertions.assertThat((String)this.dateTimeScalar.getName()).isEqualTo((Object)"DateTime");
        try {
            this.dateTimeScalar.getCoercing().serialize((Object)1);
            Assertions.fail((String)"Method should throw CoercingSerializeException");
        }
        catch (CoercingSerializeException ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo((Object)"Expected something we can convert to 'java.time.OffsetDateTime' but was 'java.lang.Integer'.");
        }
    }

    @Test
    public void testSerializeZonedDateTime() {
        Assertions.assertThat((String)this.dateTimeScalar.getName()).isEqualTo((Object)"DateTime");
        ZonedDateTime time = ZonedDateTime.now();
        String result = (String)this.dateTimeScalar.getCoercing().serialize((Object)time);
        Assertions.assertThat((String)result).isEqualTo((Object)DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(time));
    }

    @Test
    public void testSerializeMillisAsString() {
        Assertions.assertThat((String)this.dateTimeScalar.getName()).isEqualTo((Object)"DateTime");
        ZonedDateTime time = ZonedDateTime.now();
        String result = (String)this.dateTimeScalar.getCoercing().serialize((Object)String.valueOf(time.toInstant().toEpochMilli()));
        Assertions.assertThat((String)result).isEqualTo((Object)DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(time.withZoneSameInstant(ZoneOffset.UTC)));
    }

    @Test
    public void testSerializeInvalidString() {
        Assertions.assertThat((String)this.dateTimeScalar.getName()).isEqualTo((Object)"DateTime");
        try {
            this.dateTimeScalar.getCoercing().serialize((Object)"test");
            Assertions.fail((String)"Method should throw CoercingSerializeException");
        }
        catch (CoercingSerializeException ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo((Object)"Invalid RFC3339 value : 'test'. because of : 'Text 'test' could not be parsed at index 0'");
        }
    }

    @Test
    public void testSerializeString() {
        Assertions.assertThat((String)this.dateTimeScalar.getName()).isEqualTo((Object)"DateTime");
        String result = (String)this.dateTimeScalar.getCoercing().serialize((Object)"2019-08-20T19:26:02.092+00:00");
        Assertions.assertThat((String)result).isEqualTo((Object)"2019-08-20T19:26:02.092Z");
    }
}

