/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.messaging;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.index.event.KogitoProcessCloudEvent;
import org.kie.kogito.index.messaging.ReactiveMessagingEventConsumer;
import org.kie.kogito.index.service.IndexingService;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class ReactiveMessagingEventConsumerTest {
    @Mock
    IndexingService service;
    @InjectMocks
    ReactiveMessagingEventConsumer consumer;

    @Test
    public void testOnProcessInstanceDomainEvent() {
        KogitoProcessCloudEvent event = (KogitoProcessCloudEvent)Mockito.mock(KogitoProcessCloudEvent.class);
        this.consumer.onProcessInstanceDomainEvent(event);
        ((IndexingService)Mockito.verify((Object)this.service)).indexProcessInstanceModel(event);
    }

    @Test
    public void testOnProcessInstanceEvent() {
        KogitoProcessCloudEvent event = (KogitoProcessCloudEvent)Mockito.mock(KogitoProcessCloudEvent.class);
        this.consumer.onProcessInstanceEvent(event);
        ((IndexingService)Mockito.verify((Object)this.service)).indexProcessInstance(event);
    }

    @Test
    public void testOnProcessInstanceDomainEventException() {
        KogitoProcessCloudEvent event = (KogitoProcessCloudEvent)Mockito.mock(KogitoProcessCloudEvent.class);
        ((IndexingService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.service)).indexProcessInstanceModel(event);
        this.consumer.onProcessInstanceDomainEvent(event);
        ((IndexingService)Mockito.verify((Object)this.service)).indexProcessInstanceModel(event);
    }

    @Test
    public void testOnProcessInstanceEventException() {
        KogitoProcessCloudEvent event = (KogitoProcessCloudEvent)Mockito.mock(KogitoProcessCloudEvent.class);
        ((IndexingService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.service)).indexProcessInstance(event);
        this.consumer.onProcessInstanceEvent(event);
        ((IndexingService)Mockito.verify((Object)this.service)).indexProcessInstance(event);
    }
}

