/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql;

import graphql.schema.Coercing;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;

@ApplicationScoped
public class GraphQLScalarTypeProducer {
    @Produces
    public GraphQLScalarType dateTimeScalar() {
        return GraphQLScalarType.newScalar().name("DateTime").description("An RFC-3339 compliant DateTime Scalar").coercing(new Coercing(){

            public Object serialize(Object input) {
                ZonedDateTime dateTime;
                if (input instanceof ZonedDateTime) {
                    dateTime = (ZonedDateTime)input;
                } else if (input instanceof String) {
                    try {
                        dateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(input.toString())), ZoneOffset.UTC);
                    }
                    catch (NumberFormatException ex) {
                        dateTime = this.parseDateTime(input.toString());
                    }
                } else {
                    throw new CoercingSerializeException("Expected something we can convert to 'java.time.OffsetDateTime' but was '" + (input == null ? "null" : input.getClass().getName()) + "'.");
                }
                try {
                    return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(dateTime);
                }
                catch (DateTimeException e) {
                    throw new CoercingSerializeException("Unable to turn TemporalAccessor into OffsetDateTime because of : '" + e.getMessage() + "'.");
                }
            }

            private ZonedDateTime parseDateTime(String s) {
                try {
                    return ZonedDateTime.parse(s, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                }
                catch (DateTimeParseException e) {
                    throw new CoercingSerializeException("Invalid RFC3339 value : '" + s + "'. because of : '" + e.getMessage() + "'");
                }
            }

            public Object parseValue(Object input) {
                return null;
            }

            public Object parseLiteral(Object input) {
                return null;
            }
        }).build();
    }
}

