/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.PropertyDataFetcher;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPropertyDataFetcher
extends PropertyDataFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonPropertyDataFetcher.class);

    public JsonPropertyDataFetcher(String propertyName) {
        super(propertyName);
    }

    public Object get(DataFetchingEnvironment environment) {
        Object source = environment.getSource();
        if (source instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)source;
            String jsonPointer = "/" + this.getPropertyName();
            try {
                JsonValue value = jsonObject.getValue(jsonPointer);
                switch (value.getValueType()) {
                    case OBJECT: {
                        return value.asJsonObject();
                    }
                    case ARRAY: {
                        return value.asJsonArray();
                    }
                    case NUMBER: {
                        return ((JsonNumber)value).numberValue();
                    }
                    case TRUE: 
                    case FALSE: {
                        return value.toString();
                    }
                    case STRING: {
                        return ((JsonString)value).getString();
                    }
                }
                return null;
            }
            catch (JsonException ex) {
                LOGGER.warn(ex.getMessage());
                return null;
            }
        }
        return super.get(environment);
    }
}

