/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.json;

import java.util.function.Function;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.kie.kogito.index.event.KogitoProcessCloudEvent;
import org.kie.kogito.index.model.ProcessInstance;

public class ProcessInstanceMetaMapper
implements Function<KogitoProcessCloudEvent, JsonObject> {
    @Override
    public JsonObject apply(KogitoProcessCloudEvent event) {
        if (event == null) {
            return null;
        }
        ProcessInstance pi = (ProcessInstance)event.getData();
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("id", pi.getId());
        builder.add("processId", pi.getProcessId());
        if (pi.getRootProcessInstanceId() != null) {
            builder.add("rootProcessInstanceId", pi.getRootProcessInstanceId());
        }
        if (pi.getParentProcessInstanceId() != null) {
            builder.add("parentProcessInstanceId", pi.getParentProcessInstanceId());
        }
        if (pi.getRootProcessId() != null) {
            builder.add("rootProcessId", pi.getRootProcessId());
        }
        builder.add("state", pi.getState().intValue());
        if (event.getSource() != null) {
            builder.add("endpoint", event.getSource().toString());
        }
        if (pi.getStart() != null) {
            builder.add("start", pi.getStart().toInstant().toEpochMilli());
        }
        if (pi.getEnd() != null) {
            builder.add("end", pi.getEnd().toInstant().toEpochMilli());
        }
        return builder.build();
    }
}

