/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.json;

import java.util.Set;
import java.util.function.Function;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.kie.kogito.index.event.KogitoUserTaskCloudEvent;
import org.kie.kogito.index.json.JsonArrayMapper;
import org.kie.kogito.index.model.UserTaskInstance;

public class UserTaskInstanceMetaMapper
implements Function<KogitoUserTaskCloudEvent, JsonObject> {
    @Override
    public JsonObject apply(KogitoUserTaskCloudEvent event) {
        if (event == null) {
            return null;
        }
        UserTaskInstance ut = (UserTaskInstance)event.getData();
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("id", ut.getId());
        builder.add("processInstanceId", ut.getProcessInstanceId());
        builder.add("state", ut.getState());
        if (ut.getDescription() != null) {
            builder.add("description", ut.getDescription());
        }
        if (ut.getName() != null) {
            builder.add("name", ut.getName());
        }
        if (ut.getPriority() != null) {
            builder.add("priority", ut.getPriority());
        }
        if (ut.getActualOwner() != null) {
            builder.add("actualOwner", ut.getActualOwner());
        }
        this.mapArray("adminUsers", ut.getAdminUsers(), builder);
        this.mapArray("adminGroups", ut.getAdminGroups(), builder);
        this.mapArray("excludedUsers", ut.getExcludedUsers(), builder);
        this.mapArray("potentialGroups", ut.getPotentialGroups(), builder);
        this.mapArray("potentialUsers", ut.getPotentialUsers(), builder);
        if (ut.getCompleted() != null) {
            builder.add("completed", ut.getCompleted().toInstant().toEpochMilli());
        }
        if (ut.getStarted() != null) {
            builder.add("started", ut.getStarted().toInstant().toEpochMilli());
        }
        return builder.build();
    }

    private void mapArray(String attribute, Set<String> strings, JsonObjectBuilder builder) {
        if (strings != null && !strings.isEmpty()) {
            builder.add(attribute, new JsonArrayMapper().apply(strings));
        }
    }
}

