/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.messaging;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.kie.kogito.index.event.KogitoProcessCloudEvent;
import org.kie.kogito.index.event.KogitoUserTaskCloudEvent;
import org.kie.kogito.index.service.IndexingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ReactiveMessagingEventConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveMessagingEventConsumer.class);
    private static final String KOGITO_PROCESSINSTANCES_EVENTS = "kogito-processinstances-events";
    private static final String KOGITO_PROCESSDOMAIN_EVENTS = "kogito-processdomain-events";
    private static final String KOGITO_USERTASKDOMAIN_EVENTS = "kogito-usertaskdomain-events";
    private static final String KOGITO_USERTASKINSTANCES_EVENTS = "kogito-usertaskinstances-events";
    @Inject
    IndexingService indexingService;

    @Incoming(value="kogito-processinstances-events")
    public void onProcessInstanceEvent(KogitoProcessCloudEvent event) {
        try {
            LOGGER.debug("Process instance consumer received KogitoCloudEvent: \n{}", (Object)event);
            this.indexingService.indexProcessInstance(event);
        }
        catch (Exception ex) {
            LOGGER.error("Error processing KogitoCloudEvent: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    @Incoming(value="kogito-processdomain-events")
    public void onProcessInstanceDomainEvent(KogitoProcessCloudEvent event) {
        try {
            LOGGER.debug("Process domain consumer received KogitoCloudEvent: \n{}", (Object)event);
            this.indexingService.indexProcessInstanceModel(event);
        }
        catch (Exception ex) {
            LOGGER.error("Error processing KogitoCloudEvent: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    @Incoming(value="kogito-usertaskinstances-events")
    public void onUserTaskInstanceEvent(KogitoUserTaskCloudEvent event) {
        try {
            LOGGER.debug("Task instance received KogitoUserTaskCloudEvent \n{}", (Object)event);
            this.indexingService.indexUserTaskInstance(event);
        }
        catch (Exception ex) {
            LOGGER.error("Error processing KogitoUserTaskCloudEvent: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    @Incoming(value="kogito-usertaskdomain-events")
    public void onUserTaskInstanceDomainEvent(KogitoUserTaskCloudEvent event) {
        try {
            LOGGER.debug("Task domain received KogitoUserTaskCloudEvent \n{}", (Object)event);
            this.indexingService.indexUserTaskInstanceDomain(event);
        }
        catch (Exception ex) {
            LOGGER.error("Error processing KogitoUserTaskCloudEvent: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }
}

