/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.service;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.kie.kogito.index.cache.CacheService;
import org.kie.kogito.index.event.KogitoProcessCloudEvent;
import org.kie.kogito.index.event.KogitoUserTaskCloudEvent;
import org.kie.kogito.index.json.ProcessInstanceMetaMapper;
import org.kie.kogito.index.json.UserTaskInstanceMetaMapper;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.UserTaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class IndexingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexingService.class);
    @Inject
    CacheService manager;

    public void indexProcessInstance(KogitoProcessCloudEvent event) {
        ProcessInstance pi = (ProcessInstance)event.getData();
        ProcessInstance previousPI = (ProcessInstance)this.manager.getProcessInstancesCache().get(event.getProcessInstanceId());
        if (previousPI != null) {
            List nodes = previousPI.getNodes().stream().filter(n -> !pi.getNodes().contains(n)).collect(Collectors.toList());
            pi.getNodes().addAll(nodes);
        }
        this.manager.getProcessInstancesCache().put(event.getProcessInstanceId(), pi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexProcessInstanceModel(KogitoProcessCloudEvent event) {
        String processId = event.getRootProcessId() == null ? event.getProcessId() : event.getRootProcessId();
        String type = this.getModelFromProcessId(processId);
        if (type == null) {
            LOGGER.debug("Ignoring Kogito cloud event for Process Id: {}", (Object)event.getProcessId());
            return;
        }
        CacheService cacheService = this.manager;
        synchronized (cacheService) {
            Map cache = this.manager.getDomainModelCache(processId);
            if (event.getRootProcessInstanceId() == null) {
                JsonObjectBuilder builder = Json.createObjectBuilder();
                builder.add("_type", type);
                builder.add("id", event.getProcessInstanceId());
                builder.addAll(Json.createObjectBuilder((JsonObject)this.readProcessInstanceVariables(((ProcessInstance)event.getData()).getVariables())));
                JsonObject value = (JsonObject)cache.get(event.getProcessInstanceId());
                this.updateProcessInstances(builder, event, value);
                cache.put(event.getProcessInstanceId(), builder.build());
            } else {
                JsonObject value = (JsonObject)cache.get(event.getRootProcessInstanceId());
                if (value == null) {
                    LOGGER.warn("Received event for sub-process with id {}, but cache is missing entry for root process instance with id: {}", (Object)event.getProcessInstanceId(), (Object)event.getRootProcessInstanceId());
                } else {
                    JsonObjectBuilder builder = Json.createObjectBuilder((JsonObject)value);
                    builder.add("id", event.getRootProcessInstanceId());
                    this.updateProcessInstances(builder, event, value);
                    cache.put(event.getRootProcessInstanceId(), builder.build());
                }
            }
        }
    }

    private JsonObject readProcessInstanceVariables(String json) {
        try (JsonReader parser = Json.createReader((Reader)new StringReader(json));){
            JsonObject jsonObject = parser.readObject().asJsonObject();
            return jsonObject;
        }
    }

    private void updateProcessInstances(JsonObjectBuilder builder, KogitoProcessCloudEvent event, JsonObject value) {
        JsonObject jsonValue = new ProcessInstanceMetaMapper().apply(event);
        JsonArrayBuilder piBuilder = Json.createArrayBuilder().add((JsonValue)jsonValue);
        if (value != null) {
            JsonArray utArray;
            JsonArray piArray = value.getJsonArray("processInstances");
            if (piArray != null) {
                piArray.stream().filter(json -> !event.getProcessInstanceId().equals(json.asJsonObject().getString("id"))).forEach(json -> piBuilder.add(json));
            }
            if ((utArray = value.getJsonArray("userTasks")) != null) {
                builder.add("userTasks", (JsonValue)utArray);
            }
        }
        builder.add("processInstances", (JsonValue)piBuilder.build());
    }

    public String getModelFromProcessId(String processId) {
        return (String)this.manager.getProcessIdModelCache().get(processId);
    }

    public void indexUserTaskInstance(KogitoUserTaskCloudEvent event) {
        UserTaskInstance ut = (UserTaskInstance)event.getData();
        this.manager.getUserTaskInstancesCache().put(event.getUserTaskInstanceId(), ut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexUserTaskInstanceDomain(KogitoUserTaskCloudEvent event) {
        String processId = event.getRootProcessId() == null ? event.getProcessId() : event.getRootProcessId();
        String type = this.getModelFromProcessId(processId);
        if (type == null) {
            LOGGER.debug("Ignoring Kogito cloud event for User Task Id: {}", (Object)event.getUserTaskInstanceId());
            return;
        }
        CacheService cacheService = this.manager;
        synchronized (cacheService) {
            Map cache = this.manager.getDomainModelCache(processId);
            String processInstanceId = event.getRootProcessInstanceId() == null ? event.getProcessInstanceId() : event.getRootProcessInstanceId();
            JsonObject model = (JsonObject)cache.get(processInstanceId);
            if (model == null) {
                JsonObjectBuilder builder = Json.createObjectBuilder();
                builder.add("_type", type);
                builder.add("id", processInstanceId);
                this.updateTaskInstances(builder, event, null);
                cache.put(processInstanceId, builder.build());
            } else {
                JsonObjectBuilder builder = Json.createObjectBuilder((JsonObject)model);
                this.updateTaskInstances(builder, event, model);
                cache.put(processInstanceId, builder.build());
            }
        }
    }

    private void updateTaskInstances(JsonObjectBuilder builder, KogitoUserTaskCloudEvent event, JsonObject value) {
        JsonArray array;
        JsonObject jsonValue = new UserTaskInstanceMetaMapper().apply(event);
        JsonArrayBuilder utBuilder = Json.createArrayBuilder().add((JsonValue)jsonValue);
        if (value != null && (array = value.getJsonArray("userTasks")) != null) {
            array.stream().filter(json -> !event.getUserTaskInstanceId().equals(json.asJsonObject().getString("id"))).forEach(arg_0 -> ((JsonArrayBuilder)utBuilder).add(arg_0));
        }
        builder.add("userTasks", (JsonValue)utBuilder.build());
    }
}

