/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.messaging;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import org.assertj.core.api.ProxyableObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.event.KogitoProcessCloudEvent;
import org.kie.kogito.index.event.KogitoUserTaskCloudEvent;
import org.kie.kogito.index.messaging.KogitoProcessCloudEventDeserializer;
import org.kie.kogito.index.messaging.KogitoUserTaskCloudEventDeserializer;
import org.kie.kogito.index.model.ProcessInstance;

public class KogitoCloudEventDeserializerTest {
    @Test
    public void testProcessDeserializer() throws Exception {
        KogitoProcessCloudEvent event = (KogitoProcessCloudEvent)new KogitoProcessCloudEventDeserializer().deserialize(null, this.getJsonEventBytes("process_instance_event.json"));
        SoftAssertions softly = new SoftAssertions();
        ((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)softly.assertThat((Object)event).isNotNull()).hasFieldOrPropertyWithValue("id", (Object)"b50a3dd4-a955-49c4-a055-f30a4d768f87")).hasFieldOrPropertyWithValue("parentProcessInstanceId", (Object)"f8868a2e-1bbb-47eb-93cf-fa46ff9dbfee")).hasFieldOrPropertyWithValue("processId", (Object)"hotelBooking")).hasFieldOrPropertyWithValue("processInstanceId", (Object)"c2fa5c5e-3002-44c7-aef7-bce82297e3fe")).hasFieldOrPropertyWithValue("state", (Object)2)).hasFieldOrPropertyWithValue("rootProcessId", (Object)"travels")).hasFieldOrPropertyWithValue("rootProcessInstanceId", (Object)"f8868a2e-1bbb-47eb-93cf-fa46ff9dbfee")).hasFieldOrPropertyWithValue("time", (Object)ZonedDateTime.parse("2019-08-20T19:26:02.110668Z[UTC]", DateTimeFormatter.ISO_DATE_TIME))).hasFieldOrPropertyWithValue("type", (Object)"ProcessInstanceEvent")).hasFieldOrPropertyWithValue("data.id", (Object)"c2fa5c5e-3002-44c7-aef7-bce82297e3fe")).hasFieldOrPropertyWithValue("data.processId", (Object)"hotelBooking")).hasFieldOrPropertyWithValue("data.end", (Object)ZonedDateTime.parse("2019-08-20T19:26:02.092Z[UTC]", DateTimeFormatter.ISO_DATE_TIME))).hasFieldOrPropertyWithValue("data.parentProcessInstanceId", (Object)"f8868a2e-1bbb-47eb-93cf-fa46ff9dbfee")).hasFieldOrPropertyWithValue("data.processId", (Object)"hotelBooking")).hasFieldOrPropertyWithValue("data.rootProcessInstanceId", (Object)"f8868a2e-1bbb-47eb-93cf-fa46ff9dbfee")).hasFieldOrPropertyWithValue("data.rootProcessId", (Object)"travels")).hasFieldOrPropertyWithValue("data.start", (Object)ZonedDateTime.parse("2019-08-20T19:26:02.091Z[UTC]", DateTimeFormatter.ISO_DATE_TIME))).hasFieldOrPropertyWithValue("data.state", (Object)2);
        ((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)softly.assertThat(((ProcessInstance)event.getData()).getNodes().get(0)).hasFieldOrPropertyWithValue("id", (Object)"54e66e2f-2acd-4d47-b8e6-991cb6372ad8")).hasFieldOrPropertyWithValue("exit", (Object)ZonedDateTime.parse("2019-08-20T19:26:02.092Z[UTC]", DateTimeFormatter.ISO_DATE_TIME))).hasFieldOrPropertyWithValue("definitionId", (Object)"EndEvent_1")).hasFieldOrPropertyWithValue("nodeId", (Object)"3")).hasFieldOrPropertyWithValue("name", (Object)"End Event 1")).hasFieldOrPropertyWithValue("type", (Object)"EndNode")).hasFieldOrPropertyWithValue("enter", (Object)ZonedDateTime.parse("2019-08-20T19:26:02.092Z[UTC]", DateTimeFormatter.ISO_DATE_TIME));
        softly.assertAll();
    }

    @Test
    public void testUserTaskDeserializer() throws IOException {
        KogitoUserTaskCloudEvent event = (KogitoUserTaskCloudEvent)new KogitoUserTaskCloudEventDeserializer().deserialize(null, this.getJsonEventBytes("user_task_instance_event.json"));
        SoftAssertions softly = new SoftAssertions();
        ((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)softly.assertThat((Object)event).isNotNull()).hasFieldOrPropertyWithValue("id", (Object)"ef315bd2-93a9-456f-b539-d73c0c83c1df")).hasFieldOrPropertyWithValue("userTaskInstanceId", (Object)"228d5922-5e88-4bfa-8329-7116a5cbe58b")).hasFieldOrPropertyWithValue("state", (Object)"Completed")).hasFieldOrPropertyWithValue("processId", (Object)"travels")).hasFieldOrPropertyWithValue("processInstanceId", (Object)"f78fb147-ec22-4478-a592-3063add9f956")).hasFieldOrPropertyWithValue("rootProcessId", null)).hasFieldOrPropertyWithValue("rootProcessInstanceId", null)).hasFieldOrPropertyWithValue("time", (Object)ZonedDateTime.parse("2019-08-30T11:48:37.857915Z[UTC]", DateTimeFormatter.ISO_DATE_TIME))).hasFieldOrPropertyWithValue("type", (Object)"UserTaskInstanceEvent")).hasFieldOrPropertyWithValue("data.id", (Object)"228d5922-5e88-4bfa-8329-7116a5cbe58b")).hasFieldOrPropertyWithValue("data.processId", (Object)"travels")).hasFieldOrPropertyWithValue("data.processInstanceId", (Object)"f78fb147-ec22-4478-a592-3063add9f956")).hasFieldOrPropertyWithValue("data.rootProcessInstanceId", null)).hasFieldOrPropertyWithValue("data.rootProcessId", null)).hasFieldOrPropertyWithValue("data.state", (Object)"Completed")).hasFieldOrPropertyWithValue("data.description", (Object)"")).hasFieldOrPropertyWithValue("data.name", (Object)"Apply for visa")).hasFieldOrPropertyWithValue("data.referenceName", (Object)"http://localhost:8080/travels/{uuid}/ConfirmTravel/{task-uuid}")).hasFieldOrPropertyWithValue("data.priority", (Object)"1")).hasFieldOrPropertyWithValue("data.potentialGroups", Collections.emptySet())).hasFieldOrPropertyWithValue("data.potentialUsers", Collections.emptySet())).hasFieldOrPropertyWithValue("data.actualOwner", null)).hasFieldOrPropertyWithValue("data.adminGroups", Collections.emptySet())).hasFieldOrPropertyWithValue("data.adminUsers", Collections.emptySet())).hasFieldOrPropertyWithValue("data.excludedUsers", Collections.emptySet())).hasFieldOrPropertyWithValue("data.completed", (Object)ZonedDateTime.parse("2019-08-30T11:48:37.828Z[UTC]", DateTimeFormatter.ISO_DATE_TIME))).hasFieldOrPropertyWithValue("data.started", (Object)ZonedDateTime.parse("2019-08-30T11:47:42.886Z[UTC]", DateTimeFormatter.ISO_DATE_TIME));
        softly.assertAll();
    }

    private byte[] getJsonEventBytes(String file) throws IOException {
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);){
            byte[] bytes = new byte[is.available()];
            is.read(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
    }
}

