/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceState;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.query.ProcessInstanceFilter;
import org.kie.kogito.index.query.UserTaskInstanceFilter;

public class GraphQLUtils {
    private static final Map<String, Function<Object, String>> VALUE_MAPPERS = new HashMap<String, Function<Object, String>>();
    private static final Map<Class, String> QUERY_FIELDS = new HashMap<Class, String>();

    public static String toGraphQLString(UserTaskInstanceFilter filter) {
        return GraphQLUtils.toGraphQLString("UserTaskInstances", UserTaskInstance.class, UserTaskInstanceFilter.class, filter);
    }

    public static String toGraphQLString(ProcessInstanceFilter filter) {
        return GraphQLUtils.toGraphQLString("ProcessInstances", ProcessInstance.class, ProcessInstanceFilter.class, filter);
    }

    private static String toGraphQLString(String root, Class targetClass, Class filterClass, Object filter) {
        StringBuilder query = new StringBuilder();
        query.append(String.format("{ \"query\" : \"{ %s", root));
        if (filter != null) {
            String filterString = GraphQLUtils.getAllFieldsList(filterClass).filter(GraphQLUtils.getFieldPredicate(filter)).map(GraphQLUtils.getFieldStringFunction(filter)).collect(Collectors.joining(", "));
            query.append(String.format("(filter: { %s } )", filterString));
        }
        query.append(String.format("{ %s } ", QUERY_FIELDS.get(targetClass)));
        query.append("}\" }");
        return query.toString();
    }

    private static Stream<Field> getAllFieldsList(Class clazz) {
        return FieldUtils.getAllFieldsList((Class)clazz).stream().filter(f -> GraphQLUtils.getJacocoPredicate().test((Field)f));
    }

    private static Function<Field, String> getFiledName() {
        return field -> {
            if (field.getGenericType() instanceof ParameterizedType) {
                ParameterizedType genericType = (ParameterizedType)field.getGenericType();
                StringBuilder builder = new StringBuilder();
                builder.append(Arrays.stream(genericType.getActualTypeArguments()).filter(type -> type.getTypeName().startsWith("org.kie.kogito.index.model")).flatMap(type -> {
                    try {
                        return GraphQLUtils.getAllFieldsList(Class.forName(type.getTypeName()));
                    }
                    catch (Exception ex) {
                        return Stream.empty();
                    }
                }).map(f -> GraphQLUtils.getFiledName().apply((Field)f)).collect(Collectors.joining(", ")));
                if (builder.length() > 0) {
                    return field.getName() + " { " + builder.toString() + " }";
                }
            }
            if (field.getType().getName().startsWith("org.kie.kogito.index.model")) {
                return "";
            }
            return field.getName();
        };
    }

    private static Function<Field, String> getFieldStringFunction(Object filter) {
        return field -> {
            try {
                Object object = field.get(filter);
                String fieldKey = field.getDeclaringClass().getTypeName() + "." + field.getName();
                return field.getName() + ":" + VALUE_MAPPERS.getOrDefault(fieldKey, GraphQLUtils.getObjectString()).apply(object);
            }
            catch (Exception ex) {
                return "";
            }
        };
    }

    private static String getObjectString(Object object) {
        return object == null ? "null" : (object instanceof String ? "\\\"" + object + "\\\"" : object.toString());
    }

    private static Function<Object, String> getObjectString() {
        return object -> {
            if (object instanceof Collection) {
                return "[ " + ((Collection)object).stream().map(o -> GraphQLUtils.getObjectString(o)).collect(Collectors.joining(", ")).toString() + " ] ";
            }
            return GraphQLUtils.getObjectString(object);
        };
    }

    private static Predicate<Field> getJacocoPredicate() {
        return field -> !field.getName().equals("$jacocoData");
    }

    private static Predicate<Field> getFieldPredicate(Object target) {
        return field -> {
            try {
                Object param = FieldUtils.readField((Field)field, (Object)target, (boolean)true);
                return param != null;
            }
            catch (Exception ex) {
                return false;
            }
        };
    }

    static {
        VALUE_MAPPERS.put(ProcessInstanceFilter.class.getName() + ".state", states -> ((List)states).stream().map(state -> ProcessInstanceState.fromStatus((Integer)state).name()).collect(Collectors.joining(", ")));
        QUERY_FIELDS.put(UserTaskInstance.class, GraphQLUtils.getAllFieldsList(UserTaskInstance.class).map(GraphQLUtils.getFiledName()).collect(Collectors.joining(", ")));
        QUERY_FIELDS.put(ProcessInstance.class, GraphQLUtils.getAllFieldsList(ProcessInstance.class).map(GraphQLUtils.getFiledName()).collect(Collectors.joining(", ")));
        QUERY_FIELDS.computeIfPresent(ProcessInstance.class, (k, v) -> v + ", childProcessInstanceId");
    }
}

