/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.json;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.UUID;
import net.javacrumbs.jsonunit.assertj.JsonAssertion;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.TestUtils;
import org.kie.kogito.index.event.KogitoProcessCloudEvent;
import org.kie.kogito.index.json.ProcessInstanceMetaMapper;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceState;

public class ProcessInstanceMetaMapperTest {
    @Test
    public void testProcessInstanceMapper() {
        String processId = "travels";
        String rootProcessId = "root_travels";
        String processInstanceId = UUID.randomUUID().toString();
        String rootProcessInstanceId = UUID.randomUUID().toString();
        String piPrefix = "metadata.processInstances";
        KogitoProcessCloudEvent event = TestUtils.getProcessCloudEvent(processId, processInstanceId, ProcessInstanceState.COMPLETED, rootProcessInstanceId, rootProcessId, rootProcessInstanceId);
        ObjectNode json = new ProcessInstanceMetaMapper().apply(event);
        Assertions.assertThat((Iterable)json).isNotNull();
        JsonAssertions.assertThatJson((Object)json.toString()).and(new JsonAssertion[]{a -> a.node("id").isEqualTo((Object)rootProcessInstanceId), a -> a.node("processId").isEqualTo((Object)rootProcessId), a -> a.node("traveller.firstName").isEqualTo((Object)"Maciej"), a -> a.node("hotel.name").isEqualTo((Object)"Meriton"), a -> a.node("flight.flightNumber").isEqualTo((Object)"MX555"), a -> a.node("metadata").isNotNull(), a -> a.node("metadata.lastUpdate").isEqualTo((Object)event.getTime().toInstant().toEpochMilli()), a -> {
            ListAssert cfr_ignored_0 = (ListAssert)a.node(piPrefix).isArray().hasSize(1);
        }, a -> a.node(piPrefix + "[0].id").isEqualTo((Object)processInstanceId), a -> a.node(piPrefix + "[0].processId").isEqualTo((Object)processId), a -> a.node(piPrefix + "[0].rootProcessInstanceId").isEqualTo((Object)rootProcessInstanceId), a -> a.node(piPrefix + "[0].parentProcessInstanceId").isEqualTo((Object)rootProcessInstanceId), a -> a.node(piPrefix + "[0].rootProcessId").isEqualTo((Object)rootProcessId), a -> a.node(piPrefix + "[0].state").isEqualTo((Object)ProcessInstanceState.COMPLETED.ordinal()), a -> a.node(piPrefix + "[0].endpoint").isEqualTo((Object)event.getSource().toString()), a -> a.node(piPrefix + "[0].start").isEqualTo((Object)((ProcessInstance)event.getData()).getStart().toInstant().toEpochMilli()), a -> a.node(piPrefix + "[0].end").isEqualTo((Object)((ProcessInstance)event.getData()).getEnd().toInstant().toEpochMilli()), a -> a.node(piPrefix + "[0].lastUpdate").isEqualTo((Object)((ProcessInstance)event.getData()).getLastUpdate().toInstant().toEpochMilli())});
    }
}

