/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.PublicApi;
import graphql.cachecontrol.CacheControl;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.OperationDefinition;
import graphql.schema.GraphQLSchema;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dataloader.DataLoaderRegistry;

@PublicApi
public class ExecutionContextBuilder {
    private Instrumentation instrumentation;
    private ExecutionId executionId;
    private InstrumentationState instrumentationState;
    private GraphQLSchema graphQLSchema;
    private ExecutionStrategy queryStrategy;
    private ExecutionStrategy mutationStrategy;
    private ExecutionStrategy subscriptionStrategy;
    private Object context;
    private Object root;
    private Document document;
    private OperationDefinition operationDefinition;
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();
    private Map<String, FragmentDefinition> fragmentsByName = new LinkedHashMap<String, FragmentDefinition>();
    private DataLoaderRegistry dataLoaderRegistry;
    private CacheControl cacheControl;
    private List<GraphQLError> errors = new ArrayList<GraphQLError>();

    public static ExecutionContextBuilder newExecutionContextBuilder() {
        return new ExecutionContextBuilder();
    }

    public static ExecutionContextBuilder newExecutionContextBuilder(ExecutionContext other) {
        return new ExecutionContextBuilder(other);
    }

    @Internal
    public ExecutionContextBuilder() {
    }

    @Internal
    ExecutionContextBuilder(ExecutionContext other) {
        this.instrumentation = other.getInstrumentation();
        this.executionId = other.getExecutionId();
        this.instrumentationState = other.getInstrumentationState();
        this.graphQLSchema = other.getGraphQLSchema();
        this.queryStrategy = other.getQueryStrategy();
        this.mutationStrategy = other.getMutationStrategy();
        this.subscriptionStrategy = other.getSubscriptionStrategy();
        this.context = other.getContext();
        this.root = other.getRoot();
        this.document = other.getDocument();
        this.operationDefinition = other.getOperationDefinition();
        this.variables = new LinkedHashMap<String, Object>(other.getVariables());
        this.fragmentsByName = new LinkedHashMap<String, FragmentDefinition>(other.getFragmentsByName());
        this.dataLoaderRegistry = other.getDataLoaderRegistry();
        this.cacheControl = other.getCacheControl();
        this.errors = new ArrayList<GraphQLError>(other.getErrors());
    }

    public ExecutionContextBuilder instrumentation(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
        return this;
    }

    public ExecutionContextBuilder instrumentationState(InstrumentationState instrumentationState) {
        this.instrumentationState = instrumentationState;
        return this;
    }

    public ExecutionContextBuilder executionId(ExecutionId executionId) {
        this.executionId = executionId;
        return this;
    }

    public ExecutionContextBuilder graphQLSchema(GraphQLSchema graphQLSchema) {
        this.graphQLSchema = graphQLSchema;
        return this;
    }

    public ExecutionContextBuilder queryStrategy(ExecutionStrategy queryStrategy) {
        this.queryStrategy = queryStrategy;
        return this;
    }

    public ExecutionContextBuilder mutationStrategy(ExecutionStrategy mutationStrategy) {
        this.mutationStrategy = mutationStrategy;
        return this;
    }

    public ExecutionContextBuilder subscriptionStrategy(ExecutionStrategy subscriptionStrategy) {
        this.subscriptionStrategy = subscriptionStrategy;
        return this;
    }

    public ExecutionContextBuilder context(Object context) {
        this.context = context;
        return this;
    }

    public ExecutionContextBuilder root(Object root) {
        this.root = root;
        return this;
    }

    public ExecutionContextBuilder variables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public ExecutionContextBuilder fragmentsByName(Map<String, FragmentDefinition> fragmentsByName) {
        this.fragmentsByName = fragmentsByName;
        return this;
    }

    public ExecutionContextBuilder document(Document document) {
        this.document = document;
        return this;
    }

    public ExecutionContextBuilder operationDefinition(OperationDefinition operationDefinition) {
        this.operationDefinition = operationDefinition;
        return this;
    }

    public ExecutionContextBuilder dataLoaderRegistry(DataLoaderRegistry dataLoaderRegistry) {
        this.dataLoaderRegistry = Assert.assertNotNull(dataLoaderRegistry);
        return this;
    }

    public ExecutionContextBuilder cacheControl(CacheControl cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public ExecutionContext build() {
        Assert.assertNotNull(this.executionId, "You must provide a query identifier", new Object[0]);
        return new ExecutionContext(this.instrumentation, this.executionId, this.graphQLSchema, this.instrumentationState, this.queryStrategy, this.mutationStrategy, this.subscriptionStrategy, this.fragmentsByName, this.document, this.operationDefinition, this.variables, this.context, this.root, this.dataLoaderRegistry, this.cacheControl, this.errors);
    }
}

