/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.AbstractNode;
import graphql.language.Comment;
import graphql.language.IgnoredChars;
import graphql.language.Node;
import graphql.language.NodeBuilder;
import graphql.language.NodeChildrenContainer;
import graphql.language.NodeVisitor;
import graphql.language.Selection;
import graphql.language.SourceLocation;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@PublicApi
public class SelectionSet
extends AbstractNode<SelectionSet> {
    private final List<Selection> selections = new ArrayList<Selection>();
    public static final String CHILD_SELECTIONS = "selections";

    @Internal
    protected SelectionSet(Collection<? extends Selection> selections, SourceLocation sourceLocation, List<Comment> comments, IgnoredChars ignoredChars, Map<String, String> additionalData) {
        super(sourceLocation, comments, ignoredChars, additionalData);
        this.selections.addAll(selections);
    }

    public SelectionSet(Collection<? extends Selection> selections) {
        this(selections, null, new ArrayList<Comment>(), IgnoredChars.EMPTY, Collections.emptyMap());
    }

    public List<Selection> getSelections() {
        return new ArrayList<Selection>(this.selections);
    }

    public <T extends Selection> List<T> getSelectionsOfType(Class<T> selectionClass) {
        return this.selections.stream().filter(d -> selectionClass.isAssignableFrom(d.getClass())).map(selectionClass::cast).collect(Collectors.toList());
    }

    @Override
    public List<Node> getChildren() {
        return new ArrayList<Node>(this.selections);
    }

    @Override
    public NodeChildrenContainer getNamedChildren() {
        return NodeChildrenContainer.newNodeChildrenContainer().children(CHILD_SELECTIONS, this.selections).build();
    }

    @Override
    public SelectionSet withNewChildren(NodeChildrenContainer newChildren) {
        return this.transform(builder -> builder.selections(newChildren.getChildren(CHILD_SELECTIONS)));
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    @Override
    public SelectionSet deepCopy() {
        return new SelectionSet(this.deepCopy(this.selections), this.getSourceLocation(), this.getComments(), this.getIgnoredChars(), this.getAdditionalData());
    }

    public String toString() {
        return "SelectionSet{selections=" + this.selections + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitSelectionSet(this, context);
    }

    public static Builder newSelectionSet() {
        return new Builder();
    }

    public static Builder newSelectionSet(Collection<? extends Selection> selections) {
        return new Builder().selections(selections);
    }

    public SelectionSet transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeBuilder {
        private List<Selection> selections = new ArrayList<Selection>();
        private SourceLocation sourceLocation;
        private List<Comment> comments = new ArrayList<Comment>();
        private IgnoredChars ignoredChars = IgnoredChars.EMPTY;
        private Map<String, String> additionalData = new LinkedHashMap<String, String>();

        private Builder() {
        }

        private Builder(SelectionSet existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = existing.getComments();
            this.selections = existing.getSelections();
            this.ignoredChars = existing.getIgnoredChars();
            this.additionalData = existing.getAdditionalData();
        }

        public Builder selections(Collection<? extends Selection> selections) {
            this.selections = new ArrayList<Selection>(selections);
            return this;
        }

        public Builder selection(Selection selection) {
            this.selections.add(selection);
            return this;
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = comments;
            return this;
        }

        @Override
        public Builder ignoredChars(IgnoredChars ignoredChars) {
            this.ignoredChars = ignoredChars;
            return this;
        }

        @Override
        public Builder additionalData(Map<String, String> additionalData) {
            this.additionalData = Assert.assertNotNull(additionalData);
            return this;
        }

        @Override
        public Builder additionalData(String key, String value) {
            this.additionalData.put(key, value);
            return this;
        }

        public SelectionSet build() {
            return new SelectionSet(this.selections, this.sourceLocation, this.comments, this.ignoredChars, this.additionalData);
        }
    }
}

