/*
 * Decompiled with CFR 0.152.
 */
package graphql.parser;

import graphql.language.SourceLocation;
import graphql.parser.InvalidSyntaxException;
import graphql.parser.MultiSourceReader;
import graphql.parser.SourceLocationHelper;
import java.util.List;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.ParseCancellationException;

public class ExtendedBailStrategy
extends BailErrorStrategy {
    private final MultiSourceReader multiSourceReader;

    public ExtendedBailStrategy(MultiSourceReader multiSourceReader) {
        this.multiSourceReader = multiSourceReader;
    }

    @Override
    public void recover(Parser recognizer, RecognitionException e) {
        try {
            super.recover(recognizer, e);
        }
        catch (ParseCancellationException parseException) {
            throw this.mkException(recognizer, e);
        }
    }

    @Override
    public Token recoverInline(Parser recognizer) throws RecognitionException {
        try {
            return super.recoverInline(recognizer);
        }
        catch (ParseCancellationException parseException) {
            throw this.mkException(recognizer, null);
        }
    }

    InvalidSyntaxException mkMoreTokensException(Token token) {
        SourceLocation sourceLocation = SourceLocationHelper.mkSourceLocation(this.multiSourceReader, token);
        String sourcePreview = this.mkPreview(token);
        return new InvalidSyntaxException(sourceLocation, "There are more tokens in the query that have not been consumed", sourcePreview, token.getText(), null);
    }

    private InvalidSyntaxException mkException(Parser recognizer, RecognitionException cause) {
        String sourcePreview = null;
        String offendingToken = null;
        SourceLocation sourceLocation = null;
        Token currentToken = recognizer.getCurrentToken();
        if (currentToken != null) {
            sourceLocation = SourceLocationHelper.mkSourceLocation(this.multiSourceReader, currentToken);
            offendingToken = currentToken.getText();
            sourcePreview = this.mkPreview(currentToken);
        }
        return new InvalidSyntaxException(sourceLocation, null, sourcePreview, offendingToken, cause);
    }

    private String mkPreview(Token token) {
        int line = token.getLine() - 1;
        StringBuilder sb = new StringBuilder();
        int startLine = line - 3;
        int endLine = line + 3;
        List<String> lines = this.multiSourceReader.getData();
        for (int i = 0; i < lines.size(); ++i) {
            if (i < startLine || i > endLine) continue;
            sb.append(lines.get(i)).append('\n');
        }
        return sb.toString();
    }
}

