/*
 * Decompiled with CFR 0.152.
 */
package graphql.util;

import graphql.Assert;
import graphql.PublicApi;
import graphql.util.NodeAdapter;
import graphql.util.NodeMultiZipper;
import graphql.util.NodeZipper;
import graphql.util.TraversalControl;
import graphql.util.Traverser;
import graphql.util.TraverserContext;
import graphql.util.TraverserVisitor;
import java.util.Collections;
import java.util.Map;

@PublicApi
public class TreeTransformer<T> {
    private final NodeAdapter<T> nodeAdapter;

    public TreeTransformer(NodeAdapter<T> nodeAdapter) {
        this.nodeAdapter = nodeAdapter;
    }

    public T transform(T root, TraverserVisitor<T> traverserVisitor) {
        return this.transform(root, traverserVisitor, Collections.emptyMap());
    }

    public T transform(T root, final TraverserVisitor<T> traverserVisitor, Map<Class<?>, Object> rootVars) {
        Assert.assertNotNull(root);
        NodeMultiZipper<T> astMultiZipper = new NodeMultiZipper<T>(root, Collections.emptyList(), this.nodeAdapter);
        TraverserVisitor nodeTraverserVisitor = new TraverserVisitor<T>(){

            @Override
            public TraversalControl enter(TraverserContext<T> context) {
                NodeZipper nodeZipper = new NodeZipper(context.thisNode(), context.getBreadcrumbs(), TreeTransformer.this.nodeAdapter);
                context.setVar(NodeZipper.class, nodeZipper);
                context.setVar(NodeAdapter.class, TreeTransformer.this.nodeAdapter);
                return traverserVisitor.enter(context);
            }

            @Override
            public TraversalControl leave(TraverserContext<T> context) {
                return traverserVisitor.leave(context);
            }
        };
        Traverser<Object> traverser = Traverser.depthFirstWithNamedChildren(this.nodeAdapter::getNamedChildren, null, astMultiZipper);
        traverser.rootVars(rootVars);
        NodeMultiZipper multiZipperResult = (NodeMultiZipper)traverser.traverse(root, (TraverserVisitor<Object>)nodeTraverserVisitor).getAccumulatedResult();
        return multiZipperResult.toRootNode();
    }
}

