/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.List;
import java.util.Optional;

@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public class OidcConfig {
    @ConfigItem(defaultValue="true")
    public boolean enabled;
    @ConfigItem
    String authServerUrl;
    @ConfigItem
    Optional<String> introspectionPath;
    @ConfigItem
    Optional<String> jwksPath;
    @ConfigItem
    Optional<String> publicKey;
    @ConfigItem
    Optional<String> clientId;
    @ConfigItem
    Roles roles;
    @ConfigItem
    Credentials credentials;
    Authentication authentication;
    @ConfigItem(defaultValue="service")
    ApplicationType applicationType;

    public String getAuthServerUrl() {
        return this.authServerUrl;
    }

    public Optional<String> getClientId() {
        return this.clientId;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Roles getRoles() {
        return this.roles;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public static enum ApplicationType {
        WEB_APP,
        SERVICE;

    }

    @ConfigGroup
    public static class Authentication {
        @ConfigItem
        public List<String> scopes;
    }

    @ConfigGroup
    public static class Roles {
        @ConfigItem
        Optional<String> roleClaimPath;
        @ConfigItem
        Optional<String> roleClaimSeparator;

        public Optional<String> getRoleClaimPath() {
            return this.roleClaimPath;
        }

        public Optional<String> getRoleClaimSeparator() {
            return this.roleClaimSeparator;
        }

        public static Roles fromClaimPath(String path) {
            return Roles.fromClaimPathAndSeparator(path, null);
        }

        public static Roles fromClaimPathAndSeparator(String path, String sep) {
            Roles roles = new Roles();
            roles.roleClaimPath = Optional.ofNullable(path);
            roles.roleClaimSeparator = Optional.ofNullable(sep);
            return roles;
        }
    }

    @ConfigGroup
    public static class Credentials {
        @ConfigItem
        Optional<String> secret;

        public Optional<String> getSecret() {
            return this.secret;
        }
    }
}

