/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.runtime.logging.InitialConfigurator;
import java.math.BigDecimal;
import java.util.logging.Handler;
import org.jboss.logging.Logger;

public class Timing {
    private static volatile long bootStartTime = -1L;
    private static volatile long bootStopTime = -1L;
    private static volatile String httpServerInfo = "";
    private static final String UNSET_VALUE = "<<unset>>";

    public static void staticInitStarted() {
        if (bootStartTime < 0L) {
            bootStartTime = System.nanoTime();
        }
    }

    public static void staticInitStopped() {
        if (bootStopTime < 0L) {
            bootStopTime = System.nanoTime();
        }
    }

    public static void setHttpServer(String info) {
        httpServerInfo = info;
    }

    public static void mainStarted() {
    }

    public static void restart() {
        bootStartTime = System.nanoTime();
    }

    public static void printStartupTime(String name, String version, String quarkusVersion, String features, String profile, boolean liveCoding) {
        String safeAppVersion;
        long bootTimeNanoSeconds = System.nanoTime() - bootStartTime;
        Logger logger2 = Logger.getLogger("io.quarkus");
        BigDecimal secondsRepresentation = Timing.convertToBigDecimalSeconds(bootTimeNanoSeconds);
        String safeAppName = name == null || name.trim().isEmpty() ? UNSET_VALUE : name;
        String string = safeAppVersion = version == null || version.trim().isEmpty() ? UNSET_VALUE : version;
        if (UNSET_VALUE.equals(safeAppName) || UNSET_VALUE.equals(safeAppVersion)) {
            logger2.infof("Quarkus %s started in %ss. %s", (Object)quarkusVersion, (Object)secondsRepresentation, (Object)httpServerInfo);
        } else {
            logger2.infof("%s %s (running on Quarkus %s) started in %ss. %s", name, version, quarkusVersion, secondsRepresentation, httpServerInfo);
        }
        logger2.infof("Profile %s activated. %s", (Object)profile, (Object)(liveCoding ? "Live Coding activated." : ""));
        logger2.infof("Installed features: [%s]", (Object)features);
        bootStartTime = -1L;
    }

    public static void printStopTime(String name) {
        Handler[] handlers;
        long stopTimeNanoSeconds = System.nanoTime() - bootStopTime;
        Logger logger2 = Logger.getLogger("io.quarkus");
        BigDecimal secondsRepresentation = Timing.convertToBigDecimalSeconds(stopTimeNanoSeconds);
        logger2.infof("%s stopped in %ss", (Object)(UNSET_VALUE.equals(name) || name == null || name.trim().isEmpty() ? "Quarkus" : name), (Object)secondsRepresentation);
        bootStopTime = -1L;
        for (Handler handler : handlers = InitialConfigurator.DELAYED_HANDLER.clearHandlers()) {
            try {
                handler.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static BigDecimal convertToBigDecimalSeconds(long timeNanoSeconds) {
        BigDecimal secondsRepresentation = BigDecimal.valueOf(timeNanoSeconds).divide(BigDecimal.valueOf(1000000L), 4).divide(BigDecimal.valueOf(1000L), 3, 4);
        return secondsRepresentation;
    }
}

