/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.smallrye.config.SmallRyeConfig;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.ConfigProvider;

public class ConfigInstantiator {
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private static Set<String> supportedClassNameSuffix;

    public static void handleObject(Object o) {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig();
        Class<?> cls = o.getClass();
        String clsNameSuffix = ConfigInstantiator.getClassNameSuffix(o);
        if (clsNameSuffix == null) {
            return;
        }
        String name = ConfigInstantiator.dashify(cls.getSimpleName().substring(0, cls.getSimpleName().length() - clsNameSuffix.length()));
        ConfigInstantiator.handleObject("quarkus." + name, o, config);
    }

    private static void handleObject(String prefix, Object o, SmallRyeConfig config) {
        try {
            Class<?> cls = o.getClass();
            if (!ConfigInstantiator.isClassNameSuffixSupported(o)) {
                return;
            }
            for (Field field : cls.getDeclaredFields()) {
                Optional<Object> val;
                Class actualType;
                ConfigItem configItem = field.getDeclaredAnnotation(ConfigItem.class);
                Class<?> fieldClass = field.getType();
                if (configItem == null || fieldClass.isAnnotationPresent(ConfigGroup.class)) {
                    Object newInstance = fieldClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    field.set(o, newInstance);
                    ConfigInstantiator.handleObject(prefix + "." + ConfigInstantiator.dashify(field.getName()), newInstance, config);
                    continue;
                }
                String name = configItem.name();
                if (name.equals("<<hyphenated element name>>")) {
                    name = ConfigInstantiator.dashify(field.getName());
                }
                String fullName = prefix + "." + name;
                String defaultValue = configItem.defaultValue();
                if (defaultValue.equals("<<no default>>")) {
                    defaultValue = null;
                }
                Type genericType = field.getGenericType();
                boolean fieldIsOptional = fieldClass.equals(Optional.class);
                boolean fieldIsList = fieldClass.equals(List.class);
                if (fieldIsOptional) {
                    actualType = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                    val = config.getOptionalValue(fullName, actualType);
                } else if (fieldIsList) {
                    actualType = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                    val = config.getOptionalValues(fullName, actualType, ArrayList::new);
                } else {
                    val = config.getOptionalValue(fullName, fieldClass);
                }
                if (val.isPresent()) {
                    field.set(o, fieldIsOptional ? val : val.get());
                    continue;
                }
                if (defaultValue != null) {
                    if (fieldIsList) {
                        Class listType = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                        String[] parts = COMMA_PATTERN.split(defaultValue);
                        ArrayList list = new ArrayList();
                        for (String i : parts) {
                            list.add(config.convert(i, listType));
                        }
                        field.set(o, list);
                        continue;
                    }
                    if (fieldIsOptional) {
                        Class optionalType = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                        field.set(o, Optional.of(config.convert(defaultValue, optionalType)));
                        continue;
                    }
                    field.set(o, config.convert(defaultValue, fieldClass));
                    continue;
                }
                if (fieldIsOptional) {
                    field.set(o, Optional.empty());
                    continue;
                }
                if (fieldClass.equals(OptionalInt.class)) {
                    field.set(o, OptionalInt.empty());
                    continue;
                }
                if (fieldClass.equals(OptionalDouble.class)) {
                    field.set(o, OptionalDouble.empty());
                    continue;
                }
                if (!fieldClass.equals(OptionalLong.class)) continue;
                field.set(o, OptionalLong.empty());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String dashify(String substring) {
        StringBuilder ret = new StringBuilder();
        char[] chars = substring.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (i != 0 && i != chars.length - 1 && c >= 'A' && c <= 'Z') {
                ret.append('-');
            }
            ret.append(Character.toLowerCase(c));
        }
        return ret.toString();
    }

    private static String getClassNameSuffix(Object o) {
        if (o == null) {
            return null;
        }
        String klassName = o.getClass().getName();
        for (String supportedSuffix : supportedClassNameSuffix) {
            if (!klassName.endsWith(supportedSuffix)) continue;
            return supportedSuffix;
        }
        return null;
    }

    private static boolean isClassNameSuffixSupported(Object o) {
        if (o == null) {
            return false;
        }
        String klassName = o.getClass().getName();
        for (String supportedSuffix : supportedClassNameSuffix) {
            if (!klassName.endsWith(supportedSuffix)) continue;
            return true;
        }
        return false;
    }

    static {
        HashSet<String> suffixes = new HashSet<String>();
        suffixes.add("Config");
        suffixes.add("Configuration");
        supportedClassNameSuffix = Collections.unmodifiableSet(suffixes);
    }
}

