/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.AbstractDelegatingConfigSource;
import io.quarkus.runtime.configuration.ProfileManager;
import java.util.HashSet;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.wildfly.common.Assert;

public class DeploymentProfileConfigSource
extends AbstractDelegatingConfigSource {
    private final String profilePrefix;

    public static UnaryOperator<ConfigSource> wrapper() {
        return new UnaryOperator<ConfigSource>(){

            @Override
            public ConfigSource apply(ConfigSource configSource) {
                return new DeploymentProfileConfigSource(configSource, ProfileManager.getActiveProfile());
            }
        };
    }

    public DeploymentProfileConfigSource(ConfigSource delegate, String profileName) {
        super(delegate);
        Assert.checkNotNullParam("profileName", profileName);
        this.profilePrefix = "%" + profileName + ".";
    }

    @Override
    public Set<String> getPropertyNames() {
        Set<String> propertyNames = this.delegate.getPropertyNames();
        HashSet<String> ret = new HashSet<String>(propertyNames);
        for (String i : propertyNames) {
            if (!i.startsWith(this.profilePrefix)) continue;
            ret.add(i.substring(this.profilePrefix.length()));
        }
        return ret;
    }

    @Override
    public String getValue(String name) {
        String nameWithProfile;
        ConfigSource delegate = this.getDelegate();
        String result = delegate.getValue(nameWithProfile = this.profilePrefix + name);
        if (result != null) {
            return result;
        }
        return delegate.getValue(name);
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }
}

