/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.regex.Pattern;
import javax.annotation.Priority;
import org.eclipse.microprofile.config.spi.Converter;

@Priority(value=200)
public class DurationConverter
implements Converter<Duration> {
    private static final String PERIOD_OF_TIME = "PT";
    private static final Pattern DIGITS = Pattern.compile("^[-+]?\\d+$");
    private static final Pattern START_WITH_DIGITS = Pattern.compile("^[-+]?\\d+.*");

    @Override
    public Duration convert(String value) {
        if (DIGITS.asPredicate().test(value)) {
            return Duration.ofSeconds(Long.valueOf(value));
        }
        try {
            if (START_WITH_DIGITS.asPredicate().test(value)) {
                return Duration.parse(PERIOD_OF_TIME + value);
            }
            return Duration.parse(value);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

