/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import java.util.NoSuchElementException;
import org.wildfly.common.Assert;

public final class NameIterator {
    public static final int MAX_LENGTH = 2048;
    private static final int POS_MASK = 4095;
    private static final int POS_BITS = 12;
    private static final int SE_SHIFT = 20;
    private final String name;
    private int pos;
    private static final int FS_INITIAL = 0;
    private static final int FS_QUOTE = 1;
    private static final int FS_BACKSLASH = 2;
    private static final int FS_QUOTE_BACKSLASH = 3;

    public NameIterator(String name) {
        this(name, false);
    }

    public NameIterator(String name, boolean startAtEnd) {
        this(name, startAtEnd ? name.length() : -1);
    }

    public NameIterator(String name, int pos) {
        Assert.checkNotNullParam("name", name);
        if (name.length() > 2048) {
            throw new IllegalArgumentException("Name is too long");
        }
        Assert.checkMinimumParameter("pos", -1, pos);
        Assert.checkMaximumParameter("pos", name.length(), pos);
        if (pos != -1 && pos != name.length() && name.charAt(pos) != '.') {
            throw new IllegalArgumentException("Position is not located at a delimiter");
        }
        this.name = name;
        this.pos = pos;
    }

    public void goToEnd() {
        this.pos = this.name.length();
    }

    public void goToStart() {
        this.pos = -1;
    }

    public int getPosition() {
        return this.pos;
    }

    private int initIteration() {
        return this.pos & 0xFFF;
    }

    private int cookieOf(int state, int pos) {
        return state << 12 | pos & 0xFFF;
    }

    private int getPosition(int cookie) {
        return (cookie & 0xFFF) << 20 >> 20;
    }

    private int getState(int cookie) {
        return cookie >> 12;
    }

    private int nextPos(int cookie) {
        int state;
        int pos;
        block10: {
            pos = this.getPosition(cookie);
            if (this.isEndOfString(cookie)) {
                throw new NoSuchElementException();
            }
            state = this.getState(cookie);
            while (true) {
                if (++pos == this.name.length()) {
                    return this.cookieOf(state, pos);
                }
                char ch = this.name.charAt(pos);
                if (state == 0) {
                    if (ch == '.') {
                        return this.cookieOf(state, pos);
                    }
                    if (ch == '\"') {
                        state = 1;
                        continue;
                    }
                    if (ch == '\\') {
                        state = 2;
                        continue;
                    }
                    return this.cookieOf(state, pos);
                }
                if (state != 1) break block10;
                if (ch == '\"') {
                    state = 0;
                    continue;
                }
                if (ch != '\\') break;
                state = 3;
            }
            return this.cookieOf(state, pos);
        }
        if (state == 2) {
            state = 0;
            return this.cookieOf(state, pos);
        }
        assert (state == 3);
        state = 1;
        return this.cookieOf(state, pos);
    }

    private int prevPos(int cookie) {
        block9: {
            int pos = this.getPosition(cookie);
            if (this.isStartOfString(cookie)) {
                throw new NoSuchElementException();
            }
            int state = this.getState(cookie);
            while (true) {
                if (--pos == -1) {
                    return this.cookieOf(state, pos);
                }
                char ch = this.name.charAt(pos);
                if (state == 0) {
                    if (pos >= 1 && this.name.charAt(pos - 1) == '\\') {
                        return this.cookieOf(state, pos);
                    }
                    if (ch == '.') {
                        return this.cookieOf(state, pos);
                    }
                    if (ch == '\"') {
                        state = 1;
                        continue;
                    }
                    if (ch == '\\') continue;
                    return this.cookieOf(state, pos);
                }
                if (state != 1) break block9;
                if (pos >= 1 && this.name.charAt(pos - 1) == '\\') {
                    return this.cookieOf(state, pos);
                }
                if (ch == '\"') {
                    state = 0;
                    continue;
                }
                if (ch != '\\') break;
            }
            return this.cookieOf(state, pos);
        }
        throw Assert.unreachableCode();
    }

    private boolean isSegmentDelimiter(int cookie) {
        return this.isStartOfString(cookie) || this.isEndOfString(cookie) || this.getState(cookie) == 0 && this.charAt(cookie) == 46;
    }

    private boolean isEndOfString(int cookie) {
        return this.getPosition(cookie) == this.name.length();
    }

    private boolean isStartOfString(int cookie) {
        return this.getPosition(cookie) == -1;
    }

    private int charAt(int cookie) {
        return this.name.charAt(this.getPosition(cookie));
    }

    public int getPreviousStart() {
        int cookie = this.initIteration();
        while (!this.isSegmentDelimiter(cookie = this.prevPos(cookie))) {
        }
        return this.getPosition(cookie) + 1;
    }

    public int getNextEnd() {
        int cookie = this.initIteration();
        while (!this.isSegmentDelimiter(cookie = this.nextPos(cookie))) {
        }
        return this.getPosition(cookie);
    }

    public boolean nextSegmentEquals(String other) {
        return this.nextSegmentEquals(other, 0, other.length());
    }

    public boolean nextSegmentEquals(String other, int offs, int len) {
        int cookie = this.initIteration();
        int strPos = 0;
        while (!this.isSegmentDelimiter(cookie = this.nextPos(cookie))) {
            if (strPos == len) {
                return false;
            }
            if (other.charAt(offs + strPos) != this.charAt(cookie)) {
                return false;
            }
            ++strPos;
        }
        return strPos == len;
    }

    public String getNextSegment() {
        StringBuilder b = new StringBuilder();
        int cookie = this.initIteration();
        while (!this.isSegmentDelimiter(cookie = this.nextPos(cookie))) {
            b.append((char)this.charAt(cookie));
        }
        return b.toString();
    }

    public boolean previousSegmentEquals(String other) {
        return this.previousSegmentEquals(other, 0, other.length());
    }

    public boolean previousSegmentEquals(String other, int offs, int len) {
        int cookie = this.initIteration();
        int strPos = len;
        do {
            --strPos;
            if (this.isSegmentDelimiter(cookie = this.prevPos(cookie))) {
                return strPos == -1;
            }
            if (strPos != -1) continue;
            return false;
        } while (other.charAt(offs + strPos) == this.charAt(cookie));
        return false;
    }

    public String getPreviousSegment() {
        StringBuilder b = new StringBuilder();
        int cookie = this.initIteration();
        while (!this.isSegmentDelimiter(cookie = this.prevPos(cookie))) {
            b.append((char)this.charAt(cookie));
        }
        return b.reverse().toString();
    }

    public boolean hasNext() {
        return this.pos < this.name.length();
    }

    public boolean hasPrevious() {
        return this.pos > -1;
    }

    public void next() {
        this.pos = this.getNextEnd();
    }

    public void previous() {
        this.pos = this.getPreviousStart() - 1;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }
}

