/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import io.quarkus.runtime.configuration.ConfigExpander;
import io.quarkus.runtime.configuration.ExpandingConfigSource;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.wildfly.common.Assert;

final class Substitutions {
    static final FastThreadLocalInt depth = FastThreadLocalFactory.createInt();

    Substitutions() {
    }

    @TargetClass(value=ConfigProvider.class)
    static final class Target_ConfigProvider {
        @Delete
        private static ConfigProviderResolver INSTANCE;

        Target_ConfigProvider() {
        }

        @Substitute
        public static Config getConfig() {
            return ConfigProviderResolver.instance().getConfig();
        }

        @Substitute
        public static Config getConfig(ClassLoader cl) {
            return Target_ConfigProvider.getConfig();
        }
    }

    @TargetClass(value=ExpandingConfigSource.class)
    static final class Target_ExpandingConfigSource {
        @Delete
        private static ThreadLocal<Boolean> NO_EXPAND;

        Target_ExpandingConfigSource() {
        }

        @Substitute
        private static boolean isExpanding() {
            return true;
        }

        @Substitute
        public static boolean setExpanding(boolean newValue) {
            if (!newValue) {
                throw Assert.unsupported();
            }
            return true;
        }
    }

    @TargetClass(value=ConfigProviderResolver.class)
    static final class Target_ConfigurationProviderResolver {
        @Alias
        @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
        private static volatile ConfigProviderResolver instance;

        Target_ConfigurationProviderResolver() {
        }
    }

    @TargetClass(value=ConfigExpander.class)
    static final class Target_ConfigExpander {
        @Delete
        @TargetElement(name="depth")
        static ThreadLocal<int[]> origDepth = null;

        Target_ConfigExpander() {
        }

        @Substitute
        private static boolean enter() {
            int val = depth.get();
            if (val == 32) {
                return false;
            }
            depth.set(val + 1);
            return true;
        }

        @Substitute
        private static void exit() {
            depth.set(depth.get() - 1);
        }
    }
}

