/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.posix.headers.Pthread;
import java.io.PrintStream;
import java.time.Instant;
import java.util.Map;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class DiagnosticPrinter {
    public static void printDiagnostics(PrintStream w) {
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        w.println(Instant.now().toString());
        w.println("Thread dump follows:");
        for (Map.Entry<Thread, StackTraceElement[]> entry : allStackTraces.entrySet()) {
            w.println();
            Thread thread = entry.getKey();
            StackTraceElement[] stackTrace = entry.getValue();
            w.print('\"');
            w.print(thread.getName());
            w.print("\" #");
            w.print(thread.getId());
            w.print(" ");
            if (thread.isDaemon()) {
                w.print("daemon ");
            }
            w.print("prio=");
            w.print(thread.getPriority());
            w.print(" tid=");
            if (Target_PosixJavaThreads.hasThreadIdentifier(thread)) {
                long nativeId = Target_PosixJavaThreads.getPthreadIdentifier(thread).rawValue();
                w.print("0x");
                w.println(Long.toHexString(nativeId));
            } else {
                w.println("(unknown)");
            }
            w.print("   java.lang.thread.State: ");
            w.println((Object)thread.getState());
            for (StackTraceElement element : stackTrace) {
                w.print("\tat ");
                w.print(element.getClassName());
                w.print('.');
                w.print(element.getMethodName());
                w.print('(');
                String fileName = element.getFileName();
                w.print(fileName == null ? "unknown source" : fileName);
                int lineNumber = element.getLineNumber();
                if (lineNumber > 0) {
                    w.print(':');
                    w.print(lineNumber);
                }
                w.println(')');
            }
        }
    }

    @TargetClass(className="com.oracle.svm.core.posix.thread.PosixJavaThreads")
    @Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
    static final class Target_PosixJavaThreads {
        Target_PosixJavaThreads() {
        }

        @Alias
        static native Pthread.pthread_t getPthreadIdentifier(Thread var0);

        @Alias
        static native boolean hasThreadIdentifier(Thread var0);
    }
}

